/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.utils.URIBuilder;
import org.json.JSONObject;
import uk.gov.service.notify.Authentication;
import uk.gov.service.notify.LetterResponse;
import uk.gov.service.notify.Notification;
import uk.gov.service.notify.NotificationClientApi;
import uk.gov.service.notify.NotificationClientException;
import uk.gov.service.notify.NotificationList;
import uk.gov.service.notify.PdfUtils;
import uk.gov.service.notify.ReceivedTextMessageList;
import uk.gov.service.notify.RetentionPeriodDuration;
import uk.gov.service.notify.SendEmailResponse;
import uk.gov.service.notify.SendLetterResponse;
import uk.gov.service.notify.SendSmsResponse;
import uk.gov.service.notify.Template;
import uk.gov.service.notify.TemplateList;
import uk.gov.service.notify.TemplatePreview;

public class NotificationClient
implements NotificationClientApi {
    private static final Logger LOGGER = Logger.getLogger(NotificationClient.class.toString());
    private static final String LIVE_BASE_URL = "https://api.notifications.service.gov.uk";
    private final String apiKey;
    private final String serviceId;
    private final String baseUrl;
    private final Proxy proxy;
    private final String version;

    public NotificationClient(String apiKey) {
        this(apiKey, LIVE_BASE_URL, null);
    }

    public NotificationClient(String apiKey, Proxy proxy) {
        this(apiKey, LIVE_BASE_URL, proxy);
    }

    public NotificationClient(String apiKey, String baseUrl) {
        this(apiKey, baseUrl, null);
    }

    public NotificationClient(String apiKey, String baseUrl, Proxy proxy) {
        this(apiKey, baseUrl, proxy, null);
        try {
            NotificationClient.setDefaultSSLContext();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    public NotificationClient(String apiKey, String baseUrl, Proxy proxy, SSLContext sslContext) {
        this.apiKey = NotificationClient.extractApiKey(apiKey);
        this.serviceId = NotificationClient.extractServiceId(apiKey);
        this.baseUrl = baseUrl;
        this.proxy = proxy;
        if (sslContext != null) {
            NotificationClient.setCustomSSLContext(sslContext);
        }
        this.version = this.getVersion();
    }

    public String getUserAgent() {
        return "NOTIFY-API-JAVA-CLIENT/" + this.version;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public SendEmailResponse sendEmail(String templateId, String emailAddress, Map<String, ?> personalisation, String reference) throws NotificationClientException {
        return this.sendEmail(templateId, emailAddress, personalisation, reference, "", null);
    }

    @Override
    public SendEmailResponse sendEmail(String templateId, String emailAddress, Map<String, ?> personalisation, String reference, String emailReplyToId) throws NotificationClientException {
        return this.sendEmail(templateId, emailAddress, personalisation, reference, emailReplyToId, null);
    }

    @Override
    public SendEmailResponse sendEmail(String templateId, String emailAddress, Map<String, ?> personalisation, String reference, String emailReplyToId, URI oneClickUnsubscribeURL) throws NotificationClientException {
        JSONObject body = this.createBodyForPostRequest(templateId, null, emailAddress, personalisation, reference, null, null);
        if (emailReplyToId != null && !emailReplyToId.isEmpty()) {
            body.put("email_reply_to_id", (Object)emailReplyToId);
        }
        if (oneClickUnsubscribeURL != null) {
            body.put("one_click_unsubscribe_url", (Object)oneClickUnsubscribeURL);
        }
        HttpURLConnection conn = this.createConnectionAndSetHeaders(this.baseUrl + "/v2/notifications/email", "POST");
        String response = this.performPostRequest(conn, body, 201);
        return new SendEmailResponse(response);
    }

    @Override
    public SendSmsResponse sendSms(String templateId, String phoneNumber, Map<String, ?> personalisation, String reference) throws NotificationClientException {
        return this.sendSms(templateId, phoneNumber, personalisation, reference, "");
    }

    @Override
    public SendSmsResponse sendSms(String templateId, String phoneNumber, Map<String, ?> personalisation, String reference, String smsSenderId) throws NotificationClientException {
        JSONObject body = this.createBodyForPostRequest(templateId, phoneNumber, null, personalisation, reference, null, null);
        if (smsSenderId != null && !smsSenderId.isEmpty()) {
            body.put("sms_sender_id", (Object)smsSenderId);
        }
        HttpURLConnection conn = this.createConnectionAndSetHeaders(this.baseUrl + "/v2/notifications/sms", "POST");
        String response = this.performPostRequest(conn, body, 201);
        return new SendSmsResponse(response);
    }

    @Override
    public SendLetterResponse sendLetter(String templateId, Map<String, ?> personalisation, String reference) throws NotificationClientException {
        JSONObject body = this.createBodyForPostRequest(templateId, null, null, personalisation, reference, null, null);
        HttpURLConnection conn = this.createConnectionAndSetHeaders(this.baseUrl + "/v2/notifications/letter", "POST");
        String response = this.performPostRequest(conn, body, 201);
        return new SendLetterResponse(response);
    }

    @Override
    public Notification getNotificationById(String notificationId) throws NotificationClientException {
        String url = this.baseUrl + "/v2/notifications/" + notificationId;
        HttpURLConnection conn = this.createConnectionAndSetHeaders(url, "GET");
        String response = this.performGetRequest(conn);
        return new Notification(response);
    }

    @Override
    public byte[] getPdfForLetter(String notificationId) throws NotificationClientException {
        String url = this.baseUrl + "/v2/notifications/" + notificationId + "/pdf";
        HttpURLConnection conn = this.createConnectionAndSetHeaders(url, "GET");
        return this.performRawGetRequest(conn);
    }

    @Override
    public NotificationList getNotifications(String status, String notification_type, String reference, String olderThanId) throws NotificationClientException {
        try {
            URIBuilder builder = new URIBuilder(this.baseUrl + "/v2/notifications");
            if (status != null && !status.isEmpty()) {
                builder.addParameter("status", status);
            }
            if (notification_type != null && !notification_type.isEmpty()) {
                builder.addParameter("template_type", notification_type);
            }
            if (reference != null && !reference.isEmpty()) {
                builder.addParameter("reference", reference);
            }
            if (olderThanId != null && !olderThanId.isEmpty()) {
                builder.addParameter("older_than", olderThanId);
            }
            HttpURLConnection conn = this.createConnectionAndSetHeaders(builder.toString(), "GET");
            String response = this.performGetRequest(conn);
            return new NotificationList(response);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            throw new NotificationClientException(e);
        }
    }

    @Override
    public Template getTemplateById(String templateId) throws NotificationClientException {
        String url = this.baseUrl + "/v2/template/" + templateId;
        HttpURLConnection conn = this.createConnectionAndSetHeaders(url, "GET");
        String response = this.performGetRequest(conn);
        return new Template(response);
    }

    @Override
    public Template getTemplateVersion(String templateId, int version) throws NotificationClientException {
        String url = this.baseUrl + "/v2/template/" + templateId + "/version/" + version;
        HttpURLConnection conn = this.createConnectionAndSetHeaders(url, "GET");
        String response = this.performGetRequest(conn);
        return new Template(response);
    }

    @Override
    public TemplateList getAllTemplates(String templateType) throws NotificationClientException {
        try {
            URIBuilder builder = new URIBuilder(this.baseUrl + "/v2/templates");
            if (templateType != null && !templateType.isEmpty()) {
                builder.addParameter("type", templateType);
            }
            HttpURLConnection conn = this.createConnectionAndSetHeaders(builder.toString(), "GET");
            String response = this.performGetRequest(conn);
            return new TemplateList(response);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            throw new NotificationClientException(e);
        }
    }

    @Override
    public TemplatePreview generateTemplatePreview(String templateId, Map<String, Object> personalisation) throws NotificationClientException {
        JSONObject body = new JSONObject();
        if (personalisation != null && !personalisation.isEmpty()) {
            body.put("personalisation", (Object)new JSONObject(personalisation));
        }
        HttpURLConnection conn = this.createConnectionAndSetHeaders(this.baseUrl + "/v2/template/" + templateId + "/preview", "POST");
        String response = this.performPostRequest(conn, body, 200);
        return new TemplatePreview(response);
    }

    @Override
    public ReceivedTextMessageList getReceivedTextMessages(String olderThanId) throws NotificationClientException {
        try {
            URIBuilder builder = new URIBuilder(this.baseUrl + "/v2/received-text-messages");
            if (olderThanId != null && !olderThanId.isEmpty()) {
                builder.addParameter("older_than", olderThanId);
            }
            HttpURLConnection conn = this.createConnectionAndSetHeaders(builder.toString(), "GET");
            String response = this.performGetRequest(conn);
            return new ReceivedTextMessageList(response);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            throw new NotificationClientException(e);
        }
    }

    public static JSONObject prepareUpload(byte[] documentContents, String filename, boolean confirmEmailBeforeDownload, String retentionPeriod) throws NotificationClientException {
        if (documentContents.length > 0x200000) {
            throw new NotificationClientException(413, "File is larger than 2MB");
        }
        byte[] fileContentAsByte = Base64.encodeBase64((byte[])documentContents);
        String fileContent = new String(fileContentAsByte, StandardCharsets.ISO_8859_1);
        JSONObject jsonFileObject = new JSONObject();
        jsonFileObject.put("file", (Object)fileContent);
        jsonFileObject.put("filename", (Object)filename);
        jsonFileObject.put("confirm_email_before_download", confirmEmailBeforeDownload);
        jsonFileObject.put("retention_period", (Object)retentionPeriod);
        return jsonFileObject;
    }

    public static JSONObject prepareUpload(byte[] documentContents, boolean confirmEmailBeforeDownload, RetentionPeriodDuration retentionPeriod) throws NotificationClientException {
        if (documentContents.length > 0x200000) {
            throw new NotificationClientException(413, "File is larger than 2MB");
        }
        byte[] fileContentAsByte = Base64.encodeBase64((byte[])documentContents);
        String fileContent = new String(fileContentAsByte, StandardCharsets.ISO_8859_1);
        JSONObject jsonFileObject = new JSONObject();
        jsonFileObject.put("file", (Object)fileContent);
        jsonFileObject.put("filename", JSONObject.NULL);
        jsonFileObject.put("confirm_email_before_download", confirmEmailBeforeDownload);
        jsonFileObject.put("retention_period", (Object)retentionPeriod.toString());
        return jsonFileObject;
    }

    public static JSONObject prepareUpload(byte[] documentContents, String filename) throws NotificationClientException {
        if (documentContents.length > 0x200000) {
            throw new NotificationClientException(413, "File is larger than 2MB");
        }
        byte[] fileContentAsByte = Base64.encodeBase64((byte[])documentContents);
        String fileContent = new String(fileContentAsByte, StandardCharsets.ISO_8859_1);
        JSONObject jsonFileObject = new JSONObject();
        jsonFileObject.put("file", (Object)fileContent);
        jsonFileObject.put("filename", (Object)filename);
        jsonFileObject.put("confirm_email_before_download", JSONObject.NULL);
        jsonFileObject.put("retention_period", JSONObject.NULL);
        return jsonFileObject;
    }

    public static JSONObject prepareUpload(byte[] documentContents) throws NotificationClientException {
        if (documentContents.length > 0x200000) {
            throw new NotificationClientException(413, "File is larger than 2MB");
        }
        byte[] fileContentAsByte = Base64.encodeBase64((byte[])documentContents);
        String fileContent = new String(fileContentAsByte, StandardCharsets.ISO_8859_1);
        JSONObject jsonFileObject = new JSONObject();
        jsonFileObject.put("file", (Object)fileContent);
        jsonFileObject.put("filename", JSONObject.NULL);
        jsonFileObject.put("confirm_email_before_download", JSONObject.NULL);
        jsonFileObject.put("retention_period", JSONObject.NULL);
        return jsonFileObject;
    }

    public static JSONObject prepareUpload(byte[] documentContents, String filename, boolean confirmEmailBeforeDownload, RetentionPeriodDuration retentionPeriod) throws NotificationClientException {
        return NotificationClient.prepareUpload(documentContents, filename, confirmEmailBeforeDownload, retentionPeriod.toString());
    }

    private String performPostRequest(HttpURLConnection conn, JSONObject body, int expectedStatusCode) throws NotificationClientException {
        try {
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);
            wr.write(body.toString());
            wr.flush();
            int httpResult = conn.getResponseCode();
            if (httpResult == expectedStatusCode) {
                String string = this.readStream(conn.getInputStream());
                return string;
            }
            try {
                throw new NotificationClientException(httpResult, this.readStream(conn.getErrorStream()));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
                throw new NotificationClientException(e);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String performGetRequest(HttpURLConnection conn) throws NotificationClientException {
        try {
            int httpResult = conn.getResponseCode();
            if (httpResult == 200) {
                String string = this.readStream(conn.getInputStream());
                return string;
            }
            try {
                throw new NotificationClientException(httpResult, this.readStream(conn.getErrorStream()));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
                throw new NotificationClientException(e);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private byte[] performRawGetRequest(HttpURLConnection conn) throws NotificationClientException {
        byte[] out;
        block7: {
            try {
                int httpResult = conn.getResponseCode();
                if (httpResult == 200) {
                    InputStream is = conn.getInputStream();
                    out = IOUtils.toByteArray((InputStream)is);
                    break block7;
                }
                throw new NotificationClientException(httpResult, this.readStream(conn.getErrorStream()));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
                throw new NotificationClientException(e);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return out;
    }

    private HttpURLConnection createConnectionAndSetHeaders(String urlString, String method) throws NotificationClientException {
        try {
            URL url = new URL(urlString);
            HttpURLConnection conn = this.getConnection(url);
            conn.setRequestMethod(method);
            Authentication authentication = new Authentication();
            String token = authentication.create(this.serviceId, this.apiKey);
            conn.setRequestProperty("Authorization", "Bearer " + token);
            conn.setRequestProperty("User-agent", this.getUserAgent());
            if (method.equals("POST")) {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Accept", "application/json");
            }
            return conn;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            throw new NotificationClientException(e);
        }
    }

    HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection conn = null != this.proxy ? (HttpURLConnection)url.openConnection(this.proxy) : (HttpURLConnection)url.openConnection();
        return conn;
    }

    private JSONObject createBodyForPostRequest(String templateId, String phoneNumber, String emailAddress, Map<String, ?> personalisation, String reference, String encodedFileData, String postage) {
        JSONObject body = new JSONObject();
        if (phoneNumber != null && !phoneNumber.isEmpty()) {
            body.put("phone_number", (Object)phoneNumber);
        }
        if (emailAddress != null && !emailAddress.isEmpty()) {
            body.put("email_address", (Object)emailAddress);
        }
        if (templateId != null && !templateId.isEmpty()) {
            body.put("template_id", (Object)templateId);
        }
        if (personalisation != null && !personalisation.isEmpty()) {
            body.put("personalisation", personalisation);
        }
        if (reference != null && !reference.isEmpty()) {
            body.put("reference", (Object)reference);
        }
        if (encodedFileData != null && !encodedFileData.isEmpty()) {
            body.put("content", (Object)encodedFileData);
        }
        if (postage != null && !postage.isEmpty()) {
            body.put("postage", (Object)postage);
        }
        return body;
    }

    private String readStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    private static void setDefaultSSLContext() throws NoSuchAlgorithmException {
        HttpsURLConnection.setDefaultSSLSocketFactory(SSLContext.getDefault().getSocketFactory());
    }

    private static void setCustomSSLContext(SSLContext sslContext) {
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
    }

    private static String extractServiceId(String apiKey) {
        return apiKey.substring(Math.max(0, apiKey.length() - 73), Math.max(0, apiKey.length() - 37));
    }

    private static String extractApiKey(String apiKey) {
        return apiKey.substring(Math.max(0, apiKey.length() - 36));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        InputStream input = null;
        Properties prop = new Properties();
        try {
            input = this.getClass().getClassLoader().getResourceAsStream("application.properties");
            prop.load(input);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return prop.getProperty("project.version");
    }

    private LetterResponse sendPrecompiledLetter(String reference, String base64EncodedPDFFile, String postage) throws NotificationClientException {
        if (this.isBlank(reference)) {
            throw new NotificationClientException("reference cannot be null or empty");
        }
        if (this.isBlank(base64EncodedPDFFile)) {
            throw new NotificationClientException("precompiledPDF cannot be null or empty");
        }
        if (!PdfUtils.isBase64StringPDF(base64EncodedPDFFile)) {
            throw new NotificationClientException("base64EncodedPDFFile is not a PDF");
        }
        JSONObject body = this.createBodyForPostRequest(null, null, null, null, reference, base64EncodedPDFFile, postage);
        HttpURLConnection conn = this.createConnectionAndSetHeaders(this.baseUrl + "/v2/notifications/letter", "POST");
        String response = this.performPostRequest(conn, body, 201);
        return new LetterResponse(response);
    }

    private boolean isBlank(String string) {
        return Objects.isNull(string) || string.trim().length() == 0;
    }

    @Override
    public LetterResponse sendPrecompiledLetter(String reference, File precompiledPDF) throws NotificationClientException {
        return this.sendPrecompiledLetter(reference, precompiledPDF, null);
    }

    @Override
    public LetterResponse sendPrecompiledLetter(String reference, File precompiledPDF, String postage) throws NotificationClientException {
        byte[] buf;
        if (precompiledPDF == null) {
            throw new NotificationClientException("File cannot be null");
        }
        try {
            buf = FileUtils.readFileToByteArray((File)precompiledPDF);
        }
        catch (IOException e) {
            throw new NotificationClientException("Can't read file");
        }
        return this.sendPrecompiledLetterWithInputStream(reference, new ByteArrayInputStream(buf), postage);
    }

    @Override
    public LetterResponse sendPrecompiledLetterWithInputStream(String reference, InputStream stream) throws NotificationClientException {
        return this.sendPrecompiledLetterWithInputStream(reference, stream, null);
    }

    @Override
    public LetterResponse sendPrecompiledLetterWithInputStream(String reference, InputStream stream, String postage) throws NotificationClientException {
        String encoded;
        if (stream == null) {
            throw new NotificationClientException("Input stream cannot be null");
        }
        Base64InputStream base64InputStream = new Base64InputStream(stream, true, 0, null);
        try {
            encoded = IOUtils.toString((InputStream)base64InputStream, (String)"ISO-8859-1");
        }
        catch (IOException e) {
            throw new NotificationClientException("Error when turning Base64InputStream into a string");
        }
        return this.sendPrecompiledLetter(reference, encoded, postage);
    }
}

