/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.time.ZonedDateTime;
import java.util.UUID;
import org.json.JSONObject;

public class ReceivedTextMessage {
    private UUID id;
    private String notifyNumber;
    private String userNumber;
    private UUID serviceId;
    private String content;
    private ZonedDateTime createdAt;

    public ReceivedTextMessage(String json) {
        JSONObject responseBodyAsJson = new JSONObject(json);
        this.build(responseBodyAsJson);
    }

    public ReceivedTextMessage(JSONObject data) {
        this.build(data);
    }

    private void build(JSONObject data) {
        this.id = UUID.fromString(data.getString("id"));
        this.notifyNumber = data.getString("notify_number");
        this.userNumber = data.getString("user_number");
        this.serviceId = UUID.fromString(data.getString("service_id"));
        this.content = data.getString("content");
        this.createdAt = ZonedDateTime.parse(data.getString("created_at"));
    }

    public UUID getId() {
        return this.id;
    }

    public String getNotifyNumber() {
        return this.notifyNumber;
    }

    public String getUserNumber() {
        return this.userNumber;
    }

    public UUID getServiceId() {
        return this.serviceId;
    }

    public String getContent() {
        return this.content;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }
}

