/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.payments.commons.utils.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.dropwizard.db.DataSourceFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

public class DatabaseMetricsService {
    private final Set<PostgresMetric> metrics = Set.of(new PostgresGaugeMetric("numbackends", 0L), new PostgresCounterMetric("xact_commit", 0L), new PostgresCounterMetric("xact_rollback", 0L), new PostgresCounterMetric("blks_read", 0L), new PostgresCounterMetric("blks_hit", 0L), new PostgresCounterMetric("tup_returned", 0L), new PostgresCounterMetric("tup_fetched", 0L), new PostgresCounterMetric("tup_inserted", 0L), new PostgresCounterMetric("tup_updated", 0L), new PostgresCounterMetric("tup_deleted", 0L), new PostgresCounterMetric("conflicts", 0L), new PostgresCounterMetric("temp_files", 0L), new PostgresCounterMetric("temp_bytes", 0L), new PostgresCounterMetric("deadlocks", 0L), new PostgresCounterMetric("blk_read_time_ns", 0L), new PostgresCounterMetric("blk_write_time_ns", 0L));
    private final String databaseName;
    private final JDBCConnectionProvider jdbcConnectionProvider;
    private Integer statsHealthy = 0;

    public DatabaseMetricsService(DataSourceFactory dataSourceFactory, MetricRegistry metricRegistry, String databaseName) {
        this.jdbcConnectionProvider = new JDBCConnectionFactory(dataSourceFactory);
        this.databaseName = databaseName;
        this.metrics.forEach(metric -> metric.register(metricRegistry, String.format("%sdb.", databaseName)));
        metricRegistry.register(String.format("%sdb.stats_healthy", databaseName), (Metric)((Gauge)() -> this.statsHealthy));
    }

    DatabaseMetricsService(JDBCConnectionProvider jdbcConnectionProvider, MetricRegistry metricRegistry, String databaseName) {
        this.jdbcConnectionProvider = jdbcConnectionProvider;
        this.databaseName = databaseName;
        this.metrics.forEach(metric -> metric.register(metricRegistry, String.format("%sdb.", databaseName)));
        metricRegistry.register(String.format("%sdb.stats_healthy", databaseName), (Metric)((Gauge)() -> this.statsHealthy));
    }

    public void updateMetricData() {
        this.statsHealthy = this.fetchDatabaseMetrics() ? 1 : 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fetchDatabaseMetrics() {
        try (Connection connection = this.jdbcConnectionProvider.getConnection();
             PreparedStatement statement = connection.prepareStatement("select *, blk_read_time * 1000 as blk_read_time_ns, blk_write_time * 1000 as blk_write_time_ns from pg_stat_database where datname = ?");){
            connection.setReadOnly(true);
            statement.setString(1, this.databaseName);
            if (!statement.execute()) return false;
            try (ResultSet resultSet = statement.getResultSet();){
                if (!resultSet.next()) return false;
                for (PostgresMetric metric : this.metrics) {
                    metric.setValue(resultSet.getLong(metric.getName()));
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    static interface JDBCConnectionProvider {
        public Connection getConnection() throws SQLException;
    }

    private class JDBCConnectionFactory
    implements JDBCConnectionProvider {
        private DataSourceFactory dataSourceFactory;

        JDBCConnectionFactory(DataSourceFactory dataSourceFactory) {
            this.dataSourceFactory = dataSourceFactory;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return DriverManager.getConnection(this.dataSourceFactory.getUrl(), this.dataSourceFactory.getUser(), this.dataSourceFactory.getPassword());
        }
    }

    class PostgresCounterMetric
    extends Counter
    implements PostgresMetric {
        final String name;
        Long value;

        PostgresCounterMetric(String name, Long defaultValue) {
            this.name = name;
            this.value = defaultValue;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public long getCount() {
            return this.value;
        }

        @Override
        public void register(MetricRegistry registry, String prefix) {
            registry.register(String.format("%s%s", prefix, this.name), (Metric)this);
        }

        @Override
        public void setValue(Long value) {
            this.value = value;
        }
    }

    class PostgresGaugeMetric
    implements PostgresMetric,
    Gauge<Long> {
        final String name;
        Long value;

        PostgresGaugeMetric(String name, Long defaultValue) {
            this.name = name;
            this.value = defaultValue;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Long getValue() {
            return this.value;
        }

        @Override
        public void register(MetricRegistry registry, String prefix) {
            registry.register(String.format("%s%s", prefix, this.name), (Metric)this);
        }

        @Override
        public void setValue(Long value) {
            this.value = value;
        }
    }

    private static interface PostgresMetric {
        public String getName();

        public void register(MetricRegistry var1, String var2);

        public void setValue(Long var1);
    }
}

