/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.payments.commons.utils.startup;

import java.time.Duration;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.service.payments.commons.utils.startup.ApplicationStartupDependentResource;

public class ApplicationStartupDependentResourceChecker {
    private static final int PROGRESSIVE_SECONDS_TO_WAIT = 5;
    private static final Logger logger = LoggerFactory.getLogger(ApplicationStartupDependentResourceChecker.class);
    private final ApplicationStartupDependentResource applicationStartupDependentResource;
    private final Consumer<Duration> waiter;

    public ApplicationStartupDependentResourceChecker(ApplicationStartupDependentResource applicationStartupDependentResource) {
        this(applicationStartupDependentResource, duration -> {
            try {
                Thread.sleep(duration.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public ApplicationStartupDependentResourceChecker(ApplicationStartupDependentResource applicationStartupDependentResource, Consumer<Duration> waiter) {
        this.applicationStartupDependentResource = applicationStartupDependentResource;
        this.waiter = waiter;
    }

    public void checkAndWaitForResource() {
        long timeToWait = 0L;
        while (!this.applicationStartupDependentResource.isAvailable()) {
            logger.info("Waiting for {} seconds until {} is available ...", (Object)(timeToWait += 5L), (Object)this.applicationStartupDependentResource);
            this.waiter.accept(Duration.ofSeconds(timeToWait));
        }
        logger.info("{} available.", (Object)this.applicationStartupDependentResource);
    }
}

