/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.payments.commons.utils.startup;

import io.dropwizard.db.DataSourceFactory;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.service.payments.commons.utils.startup.ApplicationStartupDependentResource;

public class DatabaseStartupResource
implements ApplicationStartupDependentResource {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseStartupResource.class);
    private final String databaseUrl;
    private final String databaseUser;
    private final String databasePassword;

    public DatabaseStartupResource(DataSourceFactory dataSourceFactory) {
        this.databaseUrl = dataSourceFactory.getUrl();
        this.databaseUser = dataSourceFactory.getUser();
        this.databasePassword = dataSourceFactory.getPassword();
    }

    @Override
    public boolean isAvailable() {
        try {
            DriverManager.getConnection(this.databaseUrl, this.databaseUser, this.databasePassword).close();
            return true;
        }
        catch (SQLException e) {
            logger.warn("Unable to connect to database: {}", (Object)e.getMessage());
            return false;
        }
    }

    public String toString() {
        return String.format("DatabaseStartupResource[url=%s, user=%s]", this.databaseUrl, this.databaseUser);
    }
}

