/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.payments.commons.validation;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;

public class DateTimeUtils {
    private static final ZoneId UTC = ZoneOffset.UTC;
    private static DateTimeFormatter dateTimeFormatterAny = DateTimeFormatter.ISO_ZONED_DATE_TIME;
    private static DateTimeFormatter localDateFormatter = DateTimeFormatter.ISO_LOCAL_DATE;

    public static Optional<ZonedDateTime> toUTCZonedDateTime(String dateString) {
        try {
            ZonedDateTime utcDateTime = ZonedDateTime.parse(dateString, dateTimeFormatterAny).withZoneSameInstant(UTC);
            return Optional.of(utcDateTime);
        }
        catch (DateTimeParseException ex) {
            return Optional.empty();
        }
    }

    public static String toLocalDateString(ZonedDateTime zonedDateTime) {
        return zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toLocalDate().format(localDateFormatter);
    }

    public static Optional<ZonedDateTime> fromLocalDateOnlyString(String localDateString) {
        try {
            ZonedDateTime utcTime = LocalDate.parse(localDateString).atStartOfDay(ZoneOffset.UTC);
            return Optional.of(utcTime);
        }
        catch (DateTimeParseException ex) {
            return Optional.empty();
        }
    }
}

