/*
 * Decompiled with CFR 0.152.
 */
package com.instacart.truetime;

import com.instacart.truetime.CacheProvider;
import com.instacart.truetime.sntp.SntpResult;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/instacart/truetime/BasicCacheProvider;", "Lcom/instacart/truetime/CacheProvider;", "<init>", "()V", "stack", "Ljava/util/concurrent/LinkedBlockingDeque;", "Lcom/instacart/truetime/sntp/SntpResult;", "insert", "", "result", "fetchLatest", "fetchAll", "", "hasAnyEntries", "", "invalidate", "library_release"})
public final class BasicCacheProvider
implements CacheProvider {
    @NotNull
    private final LinkedBlockingDeque<SntpResult> stack = new LinkedBlockingDeque(3);

    @Override
    public void insert(@NotNull SntpResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (!this.stack.offerFirst(result)) {
            this.stack.removeLast();
            this.stack.addFirst(result);
        }
    }

    @Override
    @Nullable
    public SntpResult fetchLatest() {
        return this.stack.peekFirst();
    }

    @Override
    @NotNull
    public Iterable<SntpResult> fetchAll() {
        return this.stack;
    }

    @Override
    public boolean hasAnyEntries() {
        return this.stack.size() > 0;
    }

    @Override
    public void invalidate() {
        this.stack.clear();
    }
}

