/*
 * Decompiled with CFR 0.152.
 */
package com.instacart.truetime.sntp;

import android.os.SystemClock;
import com.instacart.truetime.InvalidNtpServerResponseException;
import com.instacart.truetime.SntpEventListener;
import com.instacart.truetime.sntp.Sntp;
import com.instacart.truetime.sntp.SntpResult;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.jetbrains.annotations.NotNull;

public class SntpImpl
implements Sntp {
    public static final int RESPONSE_INDEX_ORIGINATE_TIME = 0;
    public static final int RESPONSE_INDEX_RECEIVE_TIME = 1;
    public static final int RESPONSE_INDEX_TRANSMIT_TIME = 2;
    public static final int RESPONSE_INDEX_RESPONSE_TIME = 3;
    public static final int RESPONSE_INDEX_ROOT_DELAY = 4;
    public static final int RESPONSE_INDEX_DISPERSION = 5;
    public static final int RESPONSE_INDEX_STRATUM = 6;
    public static final int RESPONSE_INDEX_RESPONSE_TICKS = 7;
    public static final int RESPONSE_INDEX_SIZE = 8;
    private static final int NTP_PORT = 123;
    private static final int NTP_MODE = 3;
    private static final int NTP_VERSION = 3;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int INDEX_VERSION = 0;
    private static final int INDEX_ROOT_DELAY = 4;
    private static final int INDEX_ROOT_DISPERSION = 8;
    private static final int INDEX_ORIGINATE_TIME = 24;
    private static final int INDEX_RECEIVE_TIME = 32;
    private static final int INDEX_TRANSMIT_TIME = 40;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;

    @Override
    @NotNull
    public synchronized SntpResult requestTime(InetAddress address, float rootDelayMax, float rootDispersionMax, int serverResponseDelayMax, int timeoutInMillis, SntpEventListener listener) throws IOException {
        listener.sntpRequest(address);
        try (DatagramSocket socket = null;){
            long responseTicks;
            socket = new DatagramSocket();
            socket.setSoTimeout(timeoutInMillis);
            byte[] buffer = new byte[48];
            DatagramPacket request = new DatagramPacket(buffer, buffer.length, address, 123);
            this.writeNtpVersion(buffer);
            long requestTime = System.currentTimeMillis();
            long requestTicks = SystemClock.elapsedRealtime();
            this.writeTimeStamp(buffer, 40, requestTime);
            socket.send(request);
            long[] t = new long[8];
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            socket.receive(response);
            t[7] = responseTicks = SystemClock.elapsedRealtime();
            long originateTime = this.readTimeStamp(buffer, 24);
            long receiveTime = this.readTimeStamp(buffer, 32);
            long transmitTime = this.readTimeStamp(buffer, 40);
            long responseTime = requestTime + (responseTicks - requestTicks);
            t[0] = originateTime;
            t[1] = receiveTime;
            t[2] = transmitTime;
            t[3] = responseTime;
            t[4] = this.read(buffer, 4);
            double rootDelay = this.doubleMillis(t[4]);
            if (rootDelay > (double)rootDelayMax) {
                throw new InvalidNtpServerResponseException("Invalid response from NTP server. %s violation. %f [actual] > %f [expected]", "root_delay", (float)rootDelay, rootDelayMax);
            }
            t[5] = this.read(buffer, 8);
            double rootDispersion = this.doubleMillis(t[5]);
            if (rootDispersion > (double)rootDispersionMax) {
                throw new InvalidNtpServerResponseException("Invalid response from NTP server. %s violation. %f [actual] > %f [expected]", "root_dispersion", (float)rootDispersion, rootDispersionMax);
            }
            byte mode = (byte)(buffer[0] & 7);
            if (mode != 4 && mode != 5) {
                throw new InvalidNtpServerResponseException("untrusted mode value for TrueTime: " + mode);
            }
            int stratum = buffer[1] & 0xFF;
            t[6] = stratum;
            if (stratum < 1 || stratum > 15) {
                throw new InvalidNtpServerResponseException("untrusted stratum value for TrueTime: " + stratum);
            }
            byte leap = (byte)(buffer[0] >> 6 & 3);
            if (leap == 3) {
                throw new InvalidNtpServerResponseException("unsynchronized server responded for TrueTime");
            }
            double delay = Math.abs(responseTime - originateTime - (transmitTime - receiveTime));
            if (delay >= (double)serverResponseDelayMax) {
                throw new InvalidNtpServerResponseException("%s too large for comfort %f [actual] >= %f [expected]", "server_response_delay", (float)delay, serverResponseDelayMax);
            }
            long timeElapsedSinceRequest = Math.abs(originateTime - System.currentTimeMillis());
            if (timeElapsedSinceRequest >= 10000L) {
                throw new InvalidNtpServerResponseException("Request was sent more than 10 seconds back " + timeElapsedSinceRequest);
            }
            listener.sntpRequestSuccessful(address);
            SntpResult sntpResult = new SntpResult(t);
            return sntpResult;
        }
    }

    private void writeNtpVersion(byte[] buffer) {
        buffer[0] = 27;
    }

    private void writeTimeStamp(byte[] buffer, int offset, long time) {
        long seconds = time / 1000L;
        long milliseconds = time - seconds * 1000L;
        buffer[offset++] = (byte)((seconds += 2208988800L) >> 24);
        buffer[offset++] = (byte)(seconds >> 16);
        buffer[offset++] = (byte)(seconds >> 8);
        buffer[offset++] = (byte)(seconds >> 0);
        long fraction = milliseconds * 0x100000000L / 1000L;
        buffer[offset++] = (byte)(fraction >> 24);
        buffer[offset++] = (byte)(fraction >> 16);
        buffer[offset++] = (byte)(fraction >> 8);
        buffer[offset++] = (byte)(Math.random() * 255.0);
    }

    private long readTimeStamp(byte[] buffer, int offset) {
        long seconds = this.read(buffer, offset);
        long fraction = this.read(buffer, offset + 4);
        return (seconds - 2208988800L) * 1000L + fraction * 1000L / 0x100000000L;
    }

    private long read(byte[] buffer, int offset) {
        byte b0 = buffer[offset];
        byte b1 = buffer[offset + 1];
        byte b2 = buffer[offset + 2];
        byte b3 = buffer[offset + 3];
        return ((long)this.ui(b0) << 24) + ((long)this.ui(b1) << 16) + ((long)this.ui(b2) << 8) + (long)this.ui(b3);
    }

    private int ui(byte b) {
        return b & 0xFF;
    }

    private double doubleMillis(long fix) {
        return (double)fix / 65.536;
    }
}

