/*
 * Decompiled with CFR 0.152.
 */
package com.instacart.truetime.time;

import android.os.SystemClock;
import com.instacart.truetime.CacheProvider;
import com.instacart.truetime.TimeKeeperListener;
import com.instacart.truetime.sntp.SntpResult;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\rJ\b\u0010\u0012\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/instacart/truetime/time/TimeKeeper;", "", "listener", "Lcom/instacart/truetime/TimeKeeperListener;", "cacheProvider", "Lcom/instacart/truetime/CacheProvider;", "<init>", "(Lcom/instacart/truetime/TimeKeeperListener;Lcom/instacart/truetime/CacheProvider;)V", "save", "", "ntpResult", "Lcom/instacart/truetime/sntp/SntpResult;", "hasTheTime", "", "nowSafely", "Ljava/util/Date;", "nowTrueOnly", "hasTheTimeCalculated", "now", "library_release"})
public final class TimeKeeper {
    @NotNull
    private final TimeKeeperListener listener;
    @NotNull
    private final CacheProvider cacheProvider;

    public TimeKeeper(@NotNull TimeKeeperListener listener, @NotNull CacheProvider cacheProvider) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)cacheProvider, (String)"cacheProvider");
        this.listener = listener;
        this.cacheProvider = cacheProvider;
    }

    public final void save(@NotNull SntpResult ntpResult2) {
        Intrinsics.checkNotNullParameter((Object)ntpResult2, (String)"ntpResult");
        this.listener.storingTrueTime(ntpResult2);
        this.cacheProvider.insert(ntpResult2);
    }

    public final boolean hasTheTime() {
        boolean deviceRebooted;
        if (!this.cacheProvider.hasAnyEntries()) {
            return false;
        }
        SntpResult sntpResult = this.cacheProvider.fetchLatest();
        Intrinsics.checkNotNull((Object)sntpResult);
        SntpResult lastEntry = sntpResult;
        long currentElapsedTime = SystemClock.elapsedRealtime();
        boolean bl = deviceRebooted = lastEntry.timeSinceBoot() > currentElapsedTime;
        if (deviceRebooted) {
            this.cacheProvider.invalidate();
            this.listener.invalidateCacheOnRebootDetection();
        }
        return !deviceRebooted;
    }

    @NotNull
    public final Date nowSafely() {
        Date date;
        if (this.hasTheTime()) {
            date = this.nowTrueOnly(true);
        } else {
            this.listener.returningDeviceTime();
            date = new Date();
        }
        return date;
    }

    @NotNull
    public final Date nowTrueOnly(boolean hasTheTimeCalculated) {
        if (hasTheTimeCalculated || !this.hasTheTime()) {
            throw new IllegalStateException("TrueTime was not initialized successfully yet");
        }
        return this.now();
    }

    public static /* synthetic */ Date nowTrueOnly$default(TimeKeeper timeKeeper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return timeKeeper.nowTrueOnly(bl);
    }

    private final Date now() {
        SntpResult sntpResult = this.cacheProvider.fetchLatest();
        Intrinsics.checkNotNull((Object)sntpResult);
        SntpResult ntpResult2 = sntpResult;
        long savedSntpTime = ntpResult2.trueTime();
        long timeSinceBoot = ntpResult2.timeSinceBoot();
        long currentTimeSinceBoot = SystemClock.elapsedRealtime();
        Date trueTime = new Date(savedSntpTime + (currentTimeSinceBoot - timeSinceBoot));
        this.listener.returningTrueTime(trueTime);
        return trueTime;
    }
}

