/*
 * Decompiled with CFR 0.152.
 */
package uk.laxd.bytesize;

import java.math.BigDecimal;
import uk.laxd.bytesize.ByteUnit;

public class ByteSize {
    private static final int DEFAULT_SCALE = 2;

    public String getFormattedFileSize(BigDecimal size, ByteUnit sizePrefix, int scale) {
        ByteUnit[] prefixes = ByteUnit.SI_UNITS;
        BigDecimal converted = ByteUnit.BYTE.convert(size, sizePrefix);
        ByteUnit convertedPrefix = ByteUnit.BYTE;
        for (ByteUnit prefix : prefixes) {
            if (this.isCorrectSize(converted)) break;
            converted = prefix.convert(size, sizePrefix);
            convertedPrefix = prefix;
        }
        return converted.setScale(scale, 1).toPlainString() + convertedPrefix.getText();
    }

    public String getFormattedFileSize(BigDecimal size, ByteUnit sizePrefix) {
        return this.getFormattedFileSize(size, sizePrefix, 2);
    }

    public String getFormattedFileSize(BigDecimal size, int scale) {
        return this.getFormattedFileSize(size, ByteUnit.BYTE, scale);
    }

    public String getFormattedFileSize(BigDecimal size) {
        return this.getFormattedFileSize(size, ByteUnit.BYTE, 2);
    }

    private boolean isCorrectSize(BigDecimal size) {
        return size.compareTo(new BigDecimal("1000")) < 0;
    }
}

