/*
 * Decompiled with CFR 0.152.
 */
package uk.laxd.bytesize;

import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ByteUnit {
    BYTE(new BigDecimal("1"), ""),
    KILOBYTE(new BigDecimal("1000").pow(1), "KB"),
    MEGABYTE(new BigDecimal("1000").pow(2), "MB"),
    GIGABYTE(new BigDecimal("1000").pow(3), "GB"),
    TERABYTE(new BigDecimal("1000").pow(4), "TB"),
    PETABYTE(new BigDecimal("1000").pow(5), "PB"),
    EXABYTE(new BigDecimal("1000").pow(6), "EB"),
    ZETTABYTE(new BigDecimal("1000").pow(7), "ZB"),
    YOTTABYTE(new BigDecimal("1000").pow(8), "YB"),
    KIBIBYTE(new BigDecimal("1024").pow(1), "KiB"),
    MEBIBYTE(new BigDecimal("1024").pow(2), "MiB"),
    GIBIBYTE(new BigDecimal("1024").pow(3), "GiB"),
    TEBIBYTE(new BigDecimal("1024").pow(4), "TiB"),
    PEBIBYTE(new BigDecimal("1024").pow(5), "PiB"),
    EXBIBYTE(new BigDecimal("1024").pow(6), "EiB"),
    ZEBIBYTE(new BigDecimal("1024").pow(7), "ZiB"),
    YOBIBYTE(new BigDecimal("1024").pow(8), "YiB");

    public static ByteUnit[] SI_UNITS;
    public static ByteUnit[] BINARY_UNITS;
    private BigDecimal unitBytes;
    private String text;

    private ByteUnit(BigDecimal unitBytes, String text) {
        this.unitBytes = unitBytes;
        this.text = text;
    }

    public BigDecimal convert(BigDecimal sourceSize, ByteUnit sourcePrefix) {
        BigDecimal bytes = sourcePrefix.unitBytes.multiply(sourceSize);
        return bytes.divide(this.unitBytes);
    }

    public long convert(long sourceSize, ByteUnit sourcePrefix) {
        return this.convert(new BigDecimal(String.valueOf(sourceSize)), sourcePrefix).longValue();
    }

    public BigDecimal getUnitBytes() {
        return this.unitBytes;
    }

    public String getText() {
        return this.text;
    }

    static {
        SI_UNITS = new ByteUnit[]{KILOBYTE, MEGABYTE, GIGABYTE, TERABYTE, PETABYTE, EXABYTE, ZETTABYTE, YOTTABYTE};
        BINARY_UNITS = new ByteUnit[]{KIBIBYTE, MEBIBYTE, GIBIBYTE, TEBIBYTE, PEBIBYTE, EXBIBYTE, ZEBIBYTE, YOBIBYTE};
    }
}

