/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.convert.BeanConverter;
import uk.ltd.getahead.dwr.util.Logger;

public class HibernateBeanConverter
extends BeanConverter {
    private static Map methods = new HashMap();
    private static final String CLASS_HIBERNATE2 = "net.sf.hibernate.Hibernate";
    private static final String CLASS_HIBERNATE3 = "org.hibernate.Hibernate";
    private Class hibernate;
    private Method getClass;
    private Method isPropertyInitialized;
    private Method isInitialized;
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$convert$HibernateBeanConverter == null ? (class$uk$ltd$getahead$dwr$convert$HibernateBeanConverter = HibernateBeanConverter.class$("uk.ltd.getahead.dwr.convert.HibernateBeanConverter")) : class$uk$ltd$getahead$dwr$convert$HibernateBeanConverter);
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$convert$HibernateBeanConverter;

    public HibernateBeanConverter() throws ClassNotFoundException {
        try {
            this.hibernate = Class.forName(CLASS_HIBERNATE3);
            log.info("Found Hibernate3 class: " + this.hibernate.getName());
        }
        catch (Exception ex) {
            try {
                this.hibernate = Class.forName(CLASS_HIBERNATE2);
                log.info("Found Hibernate2 class: " + this.hibernate.getName());
            }
            catch (Exception ex2) {
                throw new ClassNotFoundException(Messages.getString("HibernateBeanConverter.MissingClass"));
            }
        }
        try {
            this.getClass = this.hibernate.getMethod("getClass", class$java$lang$Object == null ? (class$java$lang$Object = HibernateBeanConverter.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(Messages.getString("HibernateBeanConverter.MissingGetClass"));
        }
        try {
            this.isPropertyInitialized = this.hibernate.getMethod("isPropertyInitialized", class$java$lang$Object == null ? (class$java$lang$Object = HibernateBeanConverter.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$String == null ? (class$java$lang$String = HibernateBeanConverter.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (Exception ex) {
            log.info("Hibernate.isPropertyInitialized() is not available in Hibernate2 so initialization checks will not take place");
        }
        try {
            this.isInitialized = this.hibernate.getMethod("isInitialized", class$java$lang$Object == null ? (class$java$lang$Object = HibernateBeanConverter.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (Exception ex) {
            log.info("Hibernate.isInitialized() is not available - verify you have the Hibernate jar on your classpath");
        }
    }

    protected BeanInfo getBeanInfo(Object bean) throws IntrospectionException {
        try {
            Class clazz = (Class)this.getClass.invoke(null, bean);
            BeanInfo info = Introspector.getBeanInfo(clazz);
            return info;
        }
        catch (IntrospectionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error("Logic Error", ex);
            throw new IntrospectionException(ex.getMessage());
        }
    }

    public boolean isAvailable(Object data, String property) {
        try {
            if (this.isPropertyInitialized != null) {
                boolean inited;
                PropertyDescriptor[] props = Introspector.getBeanInfo(data.getClass()).getPropertyDescriptors();
                String key = data.getClass().getName() + property;
                Method method = (Method)methods.get(key);
                if (method == null) {
                    for (int i = 0; i < props.length; ++i) {
                        if (!props[i].getName().equalsIgnoreCase(property)) continue;
                        method = props[i].getReadMethod();
                    }
                    methods.put(key, method);
                }
                Boolean reply = (Boolean)this.isPropertyInitialized.invoke(null, data, property);
                Boolean reply2 = (Boolean)this.isInitialized.invoke(null, method.invoke(data, new Object[0]));
                boolean bl = inited = reply != false && reply2 != false;
                if (!inited) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            log.error("Failed in checking Hibernate the availability of " + property, ex);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

