/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import uk.ltd.getahead.dwr.AccessControl;
import uk.ltd.getahead.dwr.Call;
import uk.ltd.getahead.dwr.Calls;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.Creator;
import uk.ltd.getahead.dwr.CreatorManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.TypeHintContext;
import uk.ltd.getahead.dwr.WebContext;
import uk.ltd.getahead.dwr.WebContextFactory;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class ExecuteQuery {
    private JavascriptUtil jsutil = new JavascriptUtil();
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$impl$ExecuteQuery == null ? (class$uk$ltd$getahead$dwr$impl$ExecuteQuery = ExecuteQuery.class$("uk.ltd.getahead.dwr.impl.ExecuteQuery")) : class$uk$ltd$getahead$dwr$impl$ExecuteQuery);
    private ConverterManager converterManager = null;
    private CreatorManager creatorManager = null;
    private AccessControl accessControl = null;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$impl$ExecuteQuery;

    public ExecuteQuery(CreatorManager creatorManager, ConverterManager converterManager, AccessControl accessControl) {
        this.creatorManager = creatorManager;
        this.converterManager = converterManager;
        this.accessControl = accessControl;
    }

    public Calls execute(HttpServletRequest req) throws IOException {
        Calls calls = null;
        calls = req.getMethod().equals("GET") ? this.parseParameters(this.parseGet(req)) : this.parseParameters(this.parsePost(req));
        OutboundContext converted = new OutboundContext();
        for (int callNum = 0; callNum < calls.getCallCount(); ++callNum) {
            Call call = calls.getCall(callNum);
            InboundContext inctx = call.getInboundContext();
            try {
                Creator creator = this.creatorManager.getCreator(call.getScriptName());
                Method method = this.findMethod(call);
                if (method == null) {
                    String name = call.getScriptName() + '.' + call.getMethodName();
                    throw new IllegalArgumentException(Messages.getString("ExecuteQuery.UnknownMethod", name));
                }
                String reason = this.accessControl.getReasonToNotExecute(req, creator, call.getScriptName(), method);
                if (reason != null) {
                    log.error("Access denied: " + reason);
                    log.error("  From: " + req.getRemoteAddr() + " asking for: " + req.getRequestURI());
                    throw new SecurityException(Messages.getString("ExecuteQuery.AccessDenied"));
                }
                Object[] params = new Object[method.getParameterTypes().length];
                for (int j = 0; j < method.getParameterTypes().length; ++j) {
                    try {
                        Class<?> paramType = method.getParameterTypes()[j];
                        InboundVariable param = inctx.getParameter(callNum, j);
                        TypeHintContext incc = new TypeHintContext(method, j);
                        params[j] = this.converterManager.convertInbound(paramType, param, inctx, incc);
                        continue;
                    }
                    catch (ConversionException ex) {
                        throw new ConversionException(Messages.getString("ExecuteQuery.ConversionError", call.getScriptName(), call.getMethodName(), ex.getMessage()));
                    }
                }
                Object object = null;
                String scope = creator.getScope();
                boolean create = false;
                if (!Modifier.isStatic(method.getModifiers())) {
                    WebContext webcx = WebContextFactory.get();
                    if (scope.equals("application")) {
                        object = webcx.getServletContext().getAttribute(call.getScriptName());
                    } else if (scope.equals("session")) {
                        object = webcx.getSession().getAttribute(call.getScriptName());
                    } else if (scope.equals("request")) {
                        object = webcx.getHttpServletRequest().getAttribute(call.getScriptName());
                    }
                    if (object == null) {
                        create = true;
                        object = creator.getInstance();
                    }
                    if (scope.equals("application")) {
                        webcx.getServletContext().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("session")) {
                        webcx.getSession().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("request")) {
                        webcx.getHttpServletRequest().setAttribute(call.getScriptName(), object);
                    }
                }
                log.info("Exec[" + callNum + "]: " + call.getScriptName() + "." + call.getMethodName() + "()");
                if (log.isDebugEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    if (create) {
                        buffer.append("--Object created, ");
                        if (!scope.equals("page")) {
                            buffer.append(" stored in ");
                            buffer.append(scope);
                        } else {
                            buffer.append(" not stored");
                        }
                    } else {
                        buffer.append("--Object found in ");
                        buffer.append(scope);
                    }
                    buffer.append(". Call params (");
                    for (int j = 0; j < inctx.getParameterCount(callNum); ++j) {
                        if (j != 0) {
                            buffer.append(", ");
                        }
                        InboundVariable param = inctx.getParameter(callNum, j);
                        buffer.append(param.toString());
                    }
                    buffer.append(") id=");
                    buffer.append(call.getId());
                    buffer.append(". Using (");
                    buffer.append(calls.isXhrMode() ? "XHR" : "IFrame");
                    buffer.append(",");
                    buffer.append(req.getMethod());
                    buffer.append(")");
                    log.debug(buffer.toString());
                }
                Object reply = method.invoke(object, params);
                OutboundVariable ov = this.converterManager.convertOutbound(reply, converted);
                call.setReply(ov);
                continue;
            }
            catch (InvocationTargetException ex) {
                log.warn("Method execution failed: ", ex.getTargetException());
                call.setThrowable(this.convertException(converted, ex.getTargetException()));
                continue;
            }
            catch (Throwable ex) {
                log.warn("Method execution failed: ", ex);
                call.setThrowable(this.convertException(converted, ex));
            }
        }
        return calls;
    }

    private Map parsePost(HttpServletRequest req) throws IOException {
        String line;
        HashMap paramMap = new HashMap();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream()));
        if (in == null) {
            throw new RuntimeException(Messages.getString("ExecuteQuery.ErrorNullPost"));
        }
        int lines = 0;
        while ((line = in.readLine()) != null) {
            ++lines;
            if (line.indexOf(38) != -1) {
                log.debug("Using iframe POST mode");
                StringTokenizer st = new StringTokenizer(line, "&");
                while (st.hasMoreTokens()) {
                    String part = st.nextToken();
                    part = LocalUtil.decode(part);
                    this.parsePostLine(part, paramMap);
                }
                continue;
            }
            this.parsePostLine(line, paramMap);
        }
        log.debug("read data in " + lines + " lines");
        log.debug("pre check: paramMap.size=" + paramMap.size());
        if (paramMap.size() == 1) {
            log.debug("Using Broken Safari POST mode");
            Iterator it = paramMap.keySet().iterator();
            if (!it.hasNext()) {
                throw new IllegalStateException("No entries in non empty map!");
            }
            String key = (String)it.next();
            String value = (String)paramMap.remove(key);
            String line2 = key + "=" + value;
            StringTokenizer st = new StringTokenizer(line2, "\n");
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                part = LocalUtil.decode(part);
                this.parsePostLine(part, paramMap);
            }
            log.debug("post check: paramMap.size=" + paramMap.size());
        }
        return paramMap;
    }

    private void parsePostLine(String line, Map paramMap) {
        if (line.length() == 0) {
            return;
        }
        int sep = line.indexOf("=");
        if (sep == -1) {
            log.warn("Missing separator in POST line: " + line);
        } else {
            String key = line.substring(0, sep);
            String value = line.substring(sep + "=".length());
            paramMap.put(key, value);
        }
    }

    private Map parseGet(HttpServletRequest req) throws IOException {
        HashMap<String, String> convertedMap = new HashMap<String, String>();
        Map paramMap = req.getParameterMap();
        Iterator it = paramMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] array = (String[])paramMap.get(key);
            if (array.length == 1) {
                convertedMap.put(key, array[0]);
                continue;
            }
            throw new IOException(Messages.getString("ExecuteQuery.MultiValues", key));
        }
        return convertedMap;
    }

    private Calls parseParameters(Map paramMap) throws IOException {
        int callCount;
        Calls calls = new Calls();
        calls.setXhrMode(Boolean.valueOf((String)paramMap.remove("xml")));
        String callStr = (String)paramMap.remove("callCount");
        try {
            callCount = Integer.parseInt(callStr);
        }
        catch (NumberFormatException ex) {
            throw new IOException(Messages.getString("ExecuteQuery.BadCallCount", callStr));
        }
        for (int callNum = 0; callNum < callCount; ++callNum) {
            Call call = new Call();
            calls.addCall(call);
            String prefix = "c" + callNum + "-";
            call.setId((String)paramMap.remove(prefix + "id"));
            call.setScriptName((String)paramMap.remove(prefix + "scriptName"));
            call.setMethodName((String)paramMap.remove(prefix + "methodName"));
            Iterator it = paramMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(prefix)) continue;
                String data = (String)entry.getValue();
                String[] split = LocalUtil.splitInbound(data);
                String value = split[1];
                String type = split[0];
                call.getInboundContext().createInboundVariable(callNum, key, type, value);
                it.remove();
            }
        }
        if (paramMap.size() != 0) {
            paramMap.remove("isBrokenSafari2");
            if (paramMap.size() != 0) {
                log.warn("Entries left over in parameter map");
            }
        }
        return calls;
    }

    private Method findMethod(Call call) {
        if (call.getScriptName() == null) {
            throw new IllegalArgumentException(Messages.getString("ExecuteQuery.MissingClassParam"));
        }
        if (call.getMethodName() == null) {
            throw new IllegalArgumentException(Messages.getString("ExecuteQuery.MissingMethodParam"));
        }
        Creator creator = this.creatorManager.getCreator(call.getScriptName());
        Method[] methods = creator.getType().getMethods();
        ArrayList<Method> available = new ArrayList<Method>();
        block0: for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(call.getMethodName()) || methods[i].getParameterTypes().length != call.getInboundContext().getParameterCount()) continue;
            call.getInboundContext().clearConverted();
            for (int j = 0; j < methods[i].getParameterTypes().length; ++j) {
                Class<?> paramType = methods[i].getParameterTypes()[j];
                if (!this.converterManager.isConvertable(paramType)) continue block0;
            }
            available.add(methods[i]);
        }
        if (available.size() > 1) {
            log.warn("Warning multiple matching methods. Using first match.");
        }
        if (available.isEmpty()) {
            return null;
        }
        return (Method)available.get(0);
    }

    private OutboundVariable convertException(OutboundContext converted, Throwable th) {
        try {
            if (this.converterManager.isConvertable(th.getClass())) {
                return this.converterManager.convertOutbound(th, converted);
            }
        }
        catch (ConversionException ex) {
            log.warn("Exception while converting. Exception to be converted: " + th, ex);
        }
        OutboundVariable ov = new OutboundVariable();
        String varName = converted.getNextVariableName();
        ov.setAssignCode(varName);
        ov.setInitCode("var " + varName + " = \"" + this.jsutil.escapeJavaScript(th.getMessage()) + "\";");
        return ov;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

