/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ltd.getahead.dwr.AccessControl;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.Creator;
import uk.ltd.getahead.dwr.CreatorManager;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.Processor;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class DefaultTestProcessor
implements Processor {
    protected ConverterManager converterManager = null;
    protected CreatorManager creatorManager = null;
    protected AccessControl accessControl = null;
    private boolean allowImpossibleTests = false;
    protected final Map scriptCache = new HashMap();
    private JavascriptUtil jsutil = new JavascriptUtil();
    private static final Logger log = Logger.getLogger(class$uk$ltd$getahead$dwr$impl$DefaultTestProcessor == null ? (class$uk$ltd$getahead$dwr$impl$DefaultTestProcessor = DefaultTestProcessor.class$("uk.ltd.getahead.dwr.impl.DefaultTestProcessor")) : class$uk$ltd$getahead$dwr$impl$DefaultTestProcessor);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$impl$DefaultTestProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.creatorManager.isDebug()) {
            log.warn("Failed attempt to access test pages outside of debug mode. Set the debug init-parameter to true to enable.");
            resp.sendError(403);
            return;
        }
        String pathInfo = req.getPathInfo();
        String servletPath = req.getServletPath();
        if (pathInfo == null) {
            pathInfo = req.getServletPath();
            servletPath = "/";
        }
        String scriptName = pathInfo;
        scriptName = LocalUtil.replace(scriptName, "/test/", "");
        scriptName = LocalUtil.replace(scriptName, "/", "");
        Creator creator = this.creatorManager.getCreator(scriptName);
        Method[] methods = creator.getType().getMethods();
        resp.setContentType("text/html");
        PrintWriter out = resp.getWriter();
        String interfaceURL = req.getContextPath() + servletPath + "/interface/" + scriptName + ".js";
        String engineURL = req.getContextPath() + servletPath + "/engine.js";
        String utilURL = req.getContextPath() + servletPath + "/util.js";
        String proxyInterfaceURL = "../interface/" + scriptName + ".js";
        String proxyEngineURL = "../engine.js";
        String proxyUtilURL = "../util.js";
        out.println("<html>");
        out.println("<head>");
        out.println("  <title>DWR Test</title>");
        out.println("  <!-- These paths use .. so that they still work behind a path mapping proxy. The fully qualified version is more cut and paste friendly. -->");
        out.println("  <script type='text/javascript' src='" + proxyInterfaceURL + "'></script>");
        out.println("  <script type='text/javascript' src='" + proxyEngineURL + "'></script>");
        out.println("  <script type='text/javascript' src='" + proxyUtilURL + "'></script>");
        out.println("  <script type='text/javascript'>");
        out.println("  function objectEval(text)");
        out.println("  {");
        out.println("    // eval() breaks when we use it to get an object using the { a:42, b:'x' }");
        out.println("    // syntax because it thinks that { and } surround a block and not an object");
        out.println("    // So we wrap it in an array and extract the first element to get around");
        out.println("    // this.");
        out.println("    // The regex = [start of line][whitespace]{[stuff]}[whitespace][end of line]");
        out.println("    text = text.replace(/\\n/g, ' ');");
        out.println("    text = text.replace(/\\r/g, ' ');");
        out.println("    if (text.match(/^\\s*\\{.*\\}\\s*$/))");
        out.println("    {");
        out.println("      text = '[' + text + '][0]';");
        out.println("    }");
        out.println("    return eval(text);");
        out.println("  }");
        out.println("  </script>");
        out.println("  <style>");
        out.println("    input.itext { font-size: smaller; background: #E4E4E4; border: 0; }");
        out.println("    input.ibutton { font-size: xx-small; border: 1px outset; margin: 0px; padding: 0px; }");
        out.println("    span.reply { background: #ffffdd; white-space: pre; }");
        out.println("    span.warning { font-size: smaller; color: red; }");
        out.println("  </style>");
        out.println("</head>");
        out.println("<body onload='DWRUtil.useLoadingMessage()'>");
        out.println("");
        out.println("<h2>Methods For: " + scriptName + " (" + creator.getType().getName() + ")</h2>");
        out.println("<p>To use this class in your javascript you will need the following script includes:</p>");
        out.println("<pre>");
        out.println("  &lt;script type='text/javascript' src='<a href='" + interfaceURL + "'>" + interfaceURL + "</a>'&gt;&lt;/script&gt;");
        out.println("  &lt;script type='text/javascript' src='<a href='" + engineURL + "'>" + engineURL + "</a>'&gt;&lt;/script&gt;");
        out.println("</pre>");
        out.println("<p>In addition there is an optional utility script:</p>");
        out.println("<pre>");
        out.println("  &lt;script type='text/javascript' src='<a href='" + utilURL + "'>" + utilURL + "</a>'&gt;&lt;/script&gt;");
        out.println("</pre>");
        out.println("<p>Replies from DWR are shown with a yellow background if they are simple or in an alert box otherwise.<br/>");
        out.println("The inputs are evaluated as Javascript so strings must be quoted before execution.</p>");
        out.println("<p>There are " + methods.length + " declared methods:</p><ul>");
        for (int i = 0; i < methods.length; ++i) {
            String warning;
            int j;
            Method method = methods[i];
            String methodName = method.getName();
            String reason = this.accessControl.getReasonToNotDisplay(req, creator, scriptName, method);
            if (reason != null) {
                out.println("");
                out.println("<li style='color: #A88;'>  " + methodName + "() is not available: " + reason + "</li>");
                if (!this.allowImpossibleTests) continue;
            }
            if (this.jsutil.isReservedWord(methodName)) {
                out.println("");
                out.println("<li style='color: #88A;'>" + methodName + "() is not available because it is a reserved word.</li>");
                continue;
            }
            out.println("");
            out.println("<li>");
            out.println("  " + methodName + '(');
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int j2 = 0; j2 < paramTypes.length; ++j2) {
                Class<?> paramType = paramTypes[j2];
                if (LocalUtil.isServletClass(paramType)) {
                    out.print("AUTO");
                } else {
                    String value = "";
                    if (paramType == (class$java$lang$String == null ? DefaultTestProcessor.class$("java.lang.String") : class$java$lang$String)) {
                        value = "\"\"";
                    } else if (paramType == (class$java$lang$Boolean == null ? DefaultTestProcessor.class$("java.lang.Boolean") : class$java$lang$Boolean) || paramType == Boolean.TYPE) {
                        value = "true";
                    } else if (paramType == (class$java$lang$Integer == null ? DefaultTestProcessor.class$("java.lang.Integer") : class$java$lang$Integer) || paramType == Integer.TYPE || paramType == (class$java$lang$Short == null ? DefaultTestProcessor.class$("java.lang.Short") : class$java$lang$Short) || paramType == Short.TYPE || paramType == (class$java$lang$Long == null ? DefaultTestProcessor.class$("java.lang.Long") : class$java$lang$Long) || paramType == Long.TYPE || paramType == (class$java$lang$Byte == null ? DefaultTestProcessor.class$("java.lang.Byte") : class$java$lang$Byte) || paramType == Byte.TYPE) {
                        value = "0";
                    } else if (paramType == (class$java$lang$Float == null ? DefaultTestProcessor.class$("java.lang.Float") : class$java$lang$Float) || paramType == Float.TYPE || paramType == (class$java$lang$Double == null ? DefaultTestProcessor.class$("java.lang.Double") : class$java$lang$Double) || paramType == Double.TYPE) {
                        value = "0.0";
                    } else if (paramType.isArray() || (class$java$util$Collection == null ? DefaultTestProcessor.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(paramType)) {
                        value = "[]";
                    } else if ((class$java$util$Map == null ? DefaultTestProcessor.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(paramType)) {
                        value = "{}";
                    }
                    out.print("    <input class='itext' type='text' size='10' value='" + value + "' id='p" + i + j2 + "' title='Will be converted to: " + paramType.getName() + "'/>");
                }
                out.println(j2 == paramTypes.length - 1 ? "" : ", ");
            }
            out.println("  );");
            String onclick = scriptName + '.' + methodName + "(";
            for (int j3 = 0; j3 < paramTypes.length; ++j3) {
                if (LocalUtil.isServletClass(paramTypes[j3])) continue;
                onclick = onclick + "objectEval($(\"p" + i + j3 + "\").value), ";
            }
            onclick = onclick + "reply" + i + ");";
            out.println("  <input class='ibutton' type='button' onclick='" + onclick + "' value='Execute'  title='Calls " + scriptName + '.' + methodName + "(). View source for details.'/>");
            out.println("  <script type='text/javascript'>");
            out.println("    var reply" + i + " = function(data)");
            out.println("    {");
            out.println("      if (data != null && typeof data == 'object') alert(DWRUtil.toDescriptiveString(data, 2));");
            out.println("      else DWRUtil.setValue('d" + i + "', DWRUtil.toDescriptiveString(data, 1));");
            out.println("    }");
            out.println("  </script>");
            out.println("  <span id='d" + i + "' class='reply'></span>");
            boolean overloaded = false;
            for (j = 0; j < methods.length; ++j) {
                if (j == i || !methods[j].getName().equals(methodName)) continue;
                overloaded = true;
            }
            if (overloaded) {
                out.println("<br/><span class='warning'>(Warning: overloaded methods are not recommended. See <a href='#overloadedMethod'>below</a> for more including notes on false positives)</span>");
            }
            for (j = 0; j < paramTypes.length; ++j) {
                if (this.converterManager.isConvertable(paramTypes[j])) continue;
                out.println("<br/><span class='warning'>(Warning: No Converter for " + paramTypes[j].getName() + ". See <a href='#missingConverter'>below</a>)</span>");
            }
            if (!this.converterManager.isConvertable(method.getReturnType())) {
                out.println("<br/><span class='warning'>(Warning: No Converter for " + method.getReturnType().getName() + ". See <a href='#missingConverter'>below</a>)</span>");
            }
            if ((warning = this.accessControl.getReasonToNotExecute(req, creator, scriptName, method)) != null) {
                out.println("<br/><span class='warning'>(Warning: Role restructions in place: " + warning + ".)</span>");
            }
            out.println("</li>");
        }
        out.println("");
        out.println("</ul>");
        out.println("<h2>Other Links</h2>");
        out.println("<ul>");
        out.println("<li>Back to <a href='" + req.getContextPath() + servletPath + "/'>class index</a>.</li>");
        out.println("<li>Up to <a href='" + req.getContextPath() + "/'>top level of web app</a>.</li>");
        out.println("</ul>");
        Map map = this.scriptCache;
        synchronized (map) {
            String output = (String)this.scriptCache.get("/help.html");
            if (output == null) {
                StringBuffer buffer = new StringBuffer();
                InputStream raw = this.getClass().getResourceAsStream("/uk/ltd/getahead/dwr/help.html");
                if (raw == null) {
                    log.error(Messages.getString("DefaultProcessor.MissingHelp", "/help.html"));
                    output = "<p>Failed to read help text from resource file. Check dwr.jar is built to include html files.</p>";
                } else {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(raw));
                    while ((line = in.readLine()) != null) {
                        buffer.append(line);
                        buffer.append('\n');
                    }
                    output = buffer.toString();
                }
                this.scriptCache.put("/help.html", output);
            }
            out.println(output);
        }
        out.println("</body></html>");
        out.flush();
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setAllowImpossibleTests(boolean allowImpossibleTests) {
        this.allowImpossibleTests = allowImpossibleTests;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

