/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.marsik.ham.adif.enums.AdifEnumCode;

public enum Continent implements AdifEnumCode
{
    NORTH_AMERICA("NA"),
    SOUTH_AMERICA("SA"),
    EUROPE("EU"),
    AFRICA("AF"),
    OCEANA("OC"),
    ASIA("AS"),
    ANTARCTICA("AN");

    private final String code;
    private static final Map<String, Continent> reverse;

    private Continent(String code) {
        this.code = code;
    }

    @Override
    public String adifCode() {
        return this.code;
    }

    public static Continent findByCode(String code) {
        return reverse.get(code.toUpperCase());
    }

    static {
        reverse = new HashMap<String, Continent>();
        Stream.of(Continent.values()).forEach(v -> reverse.put(v.adifCode(), (Continent)v));
    }
}

