/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.marsik.ham.adif.enums.AdifEnumCode;

public enum QslRcvd implements AdifEnumCode
{
    RECEIVED("Y"),
    NOT_RECEIVED("N"),
    REQUESTED("R"),
    IGNORE("I"),
    VERIFIED("V");

    private final String code;
    private static final Map<String, QslRcvd> reverse;

    private QslRcvd(String code) {
        this.code = code;
    }

    @Override
    public String adifCode() {
        return this.code;
    }

    public static QslRcvd findByCode(String code) {
        return reverse.get(code.toUpperCase());
    }

    static {
        reverse = new HashMap<String, QslRcvd>();
        Stream.of(QslRcvd.values()).forEach(v -> reverse.put(v.adifCode(), (QslRcvd)v));
    }
}

