/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityDatabase;
import uk.m0nom.adifproc.activity.ActivityReader;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.activity.RemoteActivitySource;
import uk.m0nom.adifproc.activity.bota.BotaCsvReader;
import uk.m0nom.adifproc.activity.cota.CotaCsvReader;
import uk.m0nom.adifproc.activity.gma.GmaCsvReader;
import uk.m0nom.adifproc.activity.hema.HemaCsvReader;
import uk.m0nom.adifproc.activity.iota.IotaJsonReader;
import uk.m0nom.adifproc.activity.lota.LotaCsvReader;
import uk.m0nom.adifproc.activity.pota.PotaCsvReader;
import uk.m0nom.adifproc.activity.rota.RotaCsvReader;
import uk.m0nom.adifproc.activity.sota.SotaCsvReader;
import uk.m0nom.adifproc.activity.wota.WotaCsvReader;
import uk.m0nom.adifproc.activity.wwff.WwffCsvReader;

@Service
public class ActivityDatabaseService {
    private static final Logger logger = Logger.getLogger(ActivityDatabaseService.class.getName());
    private final Map<String, ActivityDatabase> databases = new HashMap<String, ActivityDatabase>();
    private final Map<ActivityType, ActivityReader> readers = new HashMap<ActivityType, ActivityReader>();

    public ActivityDatabaseService() {
        this.readers.put(ActivityType.HEMA, new HemaCsvReader("hema/HEMA-summits.csv"));
        this.readers.put(ActivityType.SOTA, new SotaCsvReader("sota/summitslist.csv"));
        this.readers.put(ActivityType.GMA, new GmaCsvReader("gma/gma_summits.csv"));
        this.readers.put(ActivityType.POTA, new PotaCsvReader("pota/all_parks_ext.csv"));
        this.readers.put(ActivityType.WOTA, new WotaCsvReader("wota/summits.csv"));
        this.readers.put(ActivityType.WWFF, new WwffCsvReader("wwff/wwff_directory.csv"));
        this.readers.put(ActivityType.COTA, new CotaCsvReader("cota/cota.csv"));
        this.readers.put(ActivityType.LOTA, new LotaCsvReader("lota/lighthouses.csv"));
        this.readers.put(ActivityType.ROTA, new RotaCsvReader("rota/2022-rota.csv"));
        this.readers.put(ActivityType.IOTA, new IotaJsonReader("iota/iota-full-list.json"));
        this.readers.put(ActivityType.BOTA, new BotaCsvReader("bota/UKBOTA-Bunker-Reference-List.csv"));
    }

    public void loadData() {
        this.readers.values().forEach(reader -> {
            boolean readingFromRemote = false;
            InputStream inputStream = null;
            if (reader instanceof RemoteActivitySource) {
                RemoteActivitySource remoteActivitySource = (RemoteActivitySource)((Object)reader);
                try {
                    inputStream = URI.create(remoteActivitySource.getRemoteUrl()).toURL().openStream();
                    if (inputStream != null) {
                        logger.info(String.format("Loading %s from %s", reader.getType().getActivityName(), remoteActivitySource.getRemoteUrl()));
                        readingFromRemote = true;
                    }
                }
                catch (IOException e) {
                    logger.warning(String.format("Problem downloading %s from %s", reader.getType().getActivityName(), remoteActivitySource.getRemoteUrl()));
                }
            }
            if (!readingFromRemote && (inputStream = this.getClass().getClassLoader().getResourceAsStream(reader.getSourceFile())) == null) {
                logger.severe(String.format("Can't load %s using classloader %s", reader.getSourceFile(), this.getClass().getClassLoader().toString()));
            }
            try {
                ActivityDatabase database = reader.read(inputStream);
                this.databases.put(reader.getType().getActivityName(), database);
            }
            catch (IOException e) {
                logger.severe(String.format("Exception thrown reading activity databases: %s", e.getMessage()));
            }
        });
    }

    public Activity findActivity(String reference) {
        for (String activityType : this.databases.keySet()) {
            ActivityDatabase database = this.getDatabase(activityType);
            Activity activity = database.get(reference);
            if (activity == null) continue;
            return activity;
        }
        return null;
    }

    public ActivityDatabase getDatabase(ActivityType type) {
        return this.databases.get(type.getActivityName());
    }

    public ActivityDatabase getDatabase(String requested) {
        return this.databases.get(requested);
    }
}

