/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity.iota;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Logger;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityDatabase;
import uk.m0nom.adifproc.activity.ActivityReader;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.activity.iota.IotaInfo;
import uk.m0nom.adifproc.activity.iota.IotaResponse;
import uk.m0nom.adifproc.maidenheadlocator.MaidenheadLocatorConversion;

public class IotaJsonReader
extends ActivityReader {
    private static final Logger logger = Logger.getLogger(IotaJsonReader.class.getName());

    public IotaJsonReader(String sourceFile) {
        super(ActivityType.IOTA, sourceFile);
    }

    @Override
    public ActivityDatabase read(InputStream inputStream) throws IOException {
        HashMap<String, Activity> iotaInfo = new HashMap<String, Activity>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            IotaResponse response = (IotaResponse)mapper.readValue(inputStream, IotaResponse.class);
            if ("ok".equals(response.getStatus())) {
                int i = 1;
                for (IotaInfo info : response.getContent()) {
                    info.setType(ActivityType.IOTA);
                    info.setRef(info.getRefNo());
                    info.setName(info.getIotaName());
                    info.setCoords(info.getCoordsFromLatLongMaxMin());
                    info.setGrid(MaidenheadLocatorConversion.coordsToLocator(info.getCoords()));
                    info.setIndex(i);
                    iotaInfo.put(info.getRefNo(), info);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            logger.severe(String.format("Error reading IOTA JSON data: %s", ex.getMessage()));
        }
        return new ActivityDatabase(ActivityType.IOTA, iotaInfo);
    }
}

