/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity.lota;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityDatabase;
import uk.m0nom.adifproc.activity.lota.LotaInfo;

public class LotaCsvWriter {
    private static final Logger logger = Logger.getLogger(LotaCsvWriter.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void write(ActivityDatabase lotaDatabase) {
        block21: {
            String[] HEADERS = new String[]{"Country", "Lighthouse Name", "DXCC", "Continent", "Location", "ILLW", "Status", "Latitude", "Longitude", "Location Source"};
            BufferedWriter out = null;
            String outPath = "target";
            String filePath = String.format("%s/%s.csv", outPath, "lighthouses");
            File outFile = null;
            TreeSet<Activity> activities = new TreeSet<Activity>(lotaDatabase.getValues());
            outFile = new File(filePath);
            out = new BufferedWriter(new FileWriter(outFile, StandardCharsets.UTF_8));
            try (CSVPrinter printer = new CSVPrinter((Appendable)out, CSVFormat.DEFAULT.withHeader(HEADERS));){
                int record = 1;
                for (Activity activity : activities) {
                    LotaInfo info = (LotaInfo)activity;
                    String latitude = "";
                    String longitude = "";
                    String locationSource = "";
                    if (info.getCoords() != null) {
                        latitude = String.format("%.5f", info.getCoords().getLatitude());
                        longitude = String.format("%.5f", info.getCoords().getLongitude());
                        locationSource = info.getCoords().getLocationInfo().toString();
                    }
                    printer.printRecord(new Object[]{info.getCountry(), info.getName(), info.getDxcc(), info.getContinent(), info.getLocation(), info.getRef(), info.getStatus(), latitude, longitude, locationSource});
                    ++record;
                }
                logger.info(String.format("Wrote %d records to %s", record, outFile.getAbsolutePath()));
            }
            try {
                assert (out != null);
                out.close();
            }
            catch (IOException ioe) {
                logger.severe(String.format("Exception closing LOTA file %s: %s", outFile.getAbsolutePath(), ioe.getMessage()));
            }
            break block21;
            catch (IOException e) {
                try {
                    logger.severe(String.format("Exception writing LOTA file %s: %s", outFile.getAbsolutePath(), e.getMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        assert (out != null);
                        out.close();
                    }
                    catch (IOException ioe) {
                        logger.severe(String.format("Exception closing LOTA file %s: %s", outFile.getAbsolutePath(), ioe.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    assert (out != null);
                    out.close();
                }
                catch (IOException ioe) {
                    logger.severe(String.format("Exception closing LOTA file %s: %s", outFile.getAbsolutePath(), ioe.getMessage()));
                }
            }
        }
    }
}

