/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity.sota;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.csv.CSVRecord;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.activity.CsvActivityReader;
import uk.m0nom.adifproc.activity.sota.SotaInfo;

public class SotaCsvReader
extends CsvActivityReader {
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/uuuu");

    public SotaCsvReader(String sourceFile) {
        super(ActivityType.SOTA, sourceFile);
    }

    @Override
    protected Activity readRecord(CSVRecord record) throws IllegalArgumentException {
        SotaInfo info = new SotaInfo();
        info.setRef(record.get("SummitCode"));
        info.setName(record.get("SummitName"));
        info.setAltitude(Double.parseDouble(record.get("AltM")));
        info.setCoords(this.readCoords(record, "Latitude", "Longitude"));
        info.setPoints(Integer.parseInt(record.get("Points")));
        info.setBonusPoints(Integer.parseInt(record.get("BonusPoints")));
        String validFrom = record.get("ValidFrom");
        info.setValidFrom(this.parseDate(validFrom, this.formatter));
        String validTo = record.get("ValidTo");
        info.setValidTo(this.parseDate(validTo, this.formatter));
        return info;
    }

    private ZonedDateTime parseDate(String s, DateTimeFormatter dateFormatter) {
        return LocalDate.parse(s, dateFormatter).atStartOfDay(ZoneOffset.UTC);
    }
}

