/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity.sota;

import java.time.ZonedDateTime;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityType;

public class SotaInfo
extends Activity {
    private int points;
    private int bonusPoints;
    private ZonedDateTime validFrom;
    private ZonedDateTime validTo;

    public SotaInfo() {
        super(ActivityType.SOTA);
    }

    @Override
    public boolean isValid(ZonedDateTime onDate) {
        return (onDate.isEqual(this.validFrom) || onDate.isAfter(this.validFrom)) && onDate.isBefore(this.validTo);
    }

    @Override
    public String getUrl() {
        return String.format("https://summits.sota.org.uk/summit/%s", this.getRef());
    }

    public int getPoints() {
        return this.points;
    }

    public int getBonusPoints() {
        return this.bonusPoints;
    }

    public ZonedDateTime getValidFrom() {
        return this.validFrom;
    }

    public ZonedDateTime getValidTo() {
        return this.validTo;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public void setBonusPoints(int bonusPoints) {
        this.bonusPoints = bonusPoints;
    }

    public void setValidFrom(ZonedDateTime validFrom) {
        this.validFrom = validFrom;
    }

    public void setValidTo(ZonedDateTime validTo) {
        this.validTo = validTo;
    }
}

