/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.print;

import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.types.Sota;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.contacts.Qsos;
import uk.m0nom.adifproc.adif3.print.ColumnConfig;
import uk.m0nom.adifproc.adif3.print.LineConfig;
import uk.m0nom.adifproc.adif3.print.PrintJobConfig;
import uk.m0nom.adifproc.geodesic.GeodesicUtils;
import uk.m0nom.adifproc.maidenheadlocator.MaidenheadLocatorConversion;

@Service
public class Adif3PrintFormatter {
    private static final Logger logger = Logger.getLogger(Adif3PrintFormatter.class.getName());
    private static final List<String> FIRSTNAME_SKIP = new ArrayList<String>(Arrays.asList("Op.", "Mr", "Mr.", "Mrs", "Mrs."));
    private final PrintJobConfig printJobConfig = new PrintJobConfig();
    private PrintState state;

    public StringBuilder format(Qsos qsos) {
        this.resetPrintState();
        for (Qso qso : qsos.getQsos()) {
            if (qso.getFrom() == null || qso.getTo() == null) continue;
            if (this.atPageBreak()) {
                this.handlePageBreak();
            }
            this.printRecord(qso);
        }
        return this.state.sb;
    }

    private void resetPrintState() {
        this.state = new PrintState();
        this.state.sb = new StringBuilder();
        this.state.currentLine = 1;
        this.state.currentPage = 1;
        this.state.currentRecord = 1;
        this.state.currentColumn = 1;
    }

    private boolean atPageBreak() {
        return this.state.currentLine == 1 || this.state.currentLine % this.printJobConfig.pageConfig.getPageHeight() == 0;
    }

    private void handlePageBreak() {
        int i;
        if (this.state.currentLine != 1) {
            this.printPageEnd();
        }
        for (i = 0; i < this.printJobConfig.pageConfig.getTopMargin(); ++i) {
            this.printLineEnd();
        }
        this.printHeader();
        for (i = 0; i < this.printJobConfig.pageConfig.getHeaderMargin(); ++i) {
            this.printLineEnd();
        }
    }

    private void printPageEnd() {
        for (int i = 0; i < this.printJobConfig.pageConfig.getBottomMargin(); ++i) {
            this.printLineEnd();
        }
        this.state.sb.append(this.printJobConfig.pageConfig.getPageEnd());
        ++this.state.currentPage;
    }

    private void printHeader() {
        if (!this.printJobConfig.pageConfig.getHeaderLine().isEmpty()) {
            if ("COLUMN_NAMES".equals(this.printJobConfig.pageConfig.getHeaderLine())) {
                this.printColumnHeaders();
            } else {
                this.state.sb.append("TODO");
            }
        }
    }

    private void printColumnHeaders() {
        StringBuilder line = new StringBuilder();
        StringBuilder separator = new StringBuilder();
        boolean printSeparator = StringUtils.length((CharSequence)this.printJobConfig.pageConfig.getHeaderSeparator()) > 0;
        LineConfig lineConfig = this.printJobConfig.pageConfig.getLine();
        List<ColumnConfig> columnConfigs = lineConfig.getColumns();
        for (ColumnConfig columnConfig : columnConfigs) {
            this.printColumnHeader(columnConfig, line);
        }
        this.printLine(line.toString());
        if (printSeparator) {
            for (ColumnConfig columnConfig : columnConfigs) {
                this.printColumnHeaderUnderline(columnConfig, separator);
            }
            this.printLine(separator.toString());
        }
    }

    private void printColumnHeader(ColumnConfig column, StringBuilder line) {
        String header = column.getHeader();
        this.printValueToColumn(column, header, line);
    }

    private void printColumnHeaderUnderline(ColumnConfig column, StringBuilder line) {
        String separator = StringUtils.repeat((char)this.printJobConfig.pageConfig.getHeaderSeparator().charAt(0), (int)column.getLength());
        this.printValueToColumn(column, separator, line);
    }

    private void printValueToColumn(ColumnConfig column, String value, StringBuilder line) {
        int position = this.state.currentColumn;
        if (position > 1) {
            ++position;
        }
        int width = column.getLength();
        String align = column.getAlign();
        if (align == null) {
            align = "left";
        }
        Object formatString = "";
        switch (align) {
            case "left": {
                formatString = "%-" + String.format("%d", width) + "s";
                break;
            }
            case "right": {
                formatString = "%" + String.format("%d", width) + "s";
            }
        }
        String content = String.format((String)formatString, value == null ? "" : value);
        if (this.state.currentColumn != position) {
            this.advanceToColumn(line, position);
        }
        content = content.substring(0, width);
        line.append(content);
        this.state.currentColumn += width;
    }

    private void advanceToColumn(StringBuilder line, int position) {
        boolean first = true;
        for (int i = this.state.currentColumn; i < position; ++i) {
            if (first) {
                line.append(this.printJobConfig.pageConfig.getColumnSeparator());
                first = false;
            } else {
                line.append(' ');
            }
            ++this.state.currentColumn;
        }
    }

    private void printLine(String line) {
        this.state.sb.append(this.printJobConfig.pageConfig.getColumnSeparator());
        this.state.sb.append(line);
        this.state.sb.append(this.printJobConfig.pageConfig.getColumnSeparator());
        this.printLineEnd();
    }

    private void printLineEnd() {
        if ("unix".equals(this.printJobConfig.pageConfig.getLineEnd())) {
            this.state.sb.append("\n");
        } else {
            this.state.sb.append("\r\n");
        }
        ++this.state.currentLine;
        this.state.currentColumn = 1;
    }

    public void printRecord(Qso qso) {
        StringBuilder line = new StringBuilder();
        for (ColumnConfig column : this.printJobConfig.pageConfig.getLine().getColumns()) {
            String value = this.getAdif3FieldFromRecord(qso, column);
            this.printValueToColumn(column, value, line);
        }
        this.printLine(line.toString());
    }

    private String getAdif3FieldFromRecord(Qso qso, ColumnConfig column) {
        String value = "";
        Adif3Record rec = qso.getRecord();
        boolean markdown = "md".equals(this.printJobConfig.filenameExtension);
        switch (column.getAdif()) {
            case "QSO_DATE": {
                ZonedDateTime date = rec.getQsoDate();
                if (date == null) break;
                DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(column.getFormat());
                value = date.format(dateFormat);
                break;
            }
            case "TIME_ON": {
                LocalTime time = rec.getTimeOn();
                if (time == null) break;
                DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern(column.getFormat());
                value = time.format(timeFormat);
                break;
            }
            case "STATION_CALLSIGN": {
                if (markdown && qso.getFrom().getQrzInfo() != null) {
                    value = String.format("[%s](https://qrz.com/db/%s)", qso.getFrom().getCallsign(), qso.getFrom().getQrzInfo().getCall());
                    break;
                }
                value = rec.getStationCallsign();
                break;
            }
            case "CALL": {
                if (markdown && qso.getTo().getQrzInfo() != null) {
                    value = String.format("[%s](https://qrz.com/db/%s)", qso.getTo().getCallsign(), qso.getTo().getQrzInfo().getCall());
                    break;
                }
                value = rec.getCall();
                break;
            }
            case "BAND": {
                if (rec.getBand() == null) break;
                value = rec.getBand().adifCode();
                break;
            }
            case "FREQ": {
                if (rec.getFreq() == null) break;
                Double freq = rec.getFreq();
                value = String.format(column.getFormat(), freq);
                break;
            }
            case "MODE": {
                if (rec.getMode() == null) break;
                value = rec.getMode().adifCode();
                break;
            }
            case "RST_RCVD": {
                value = rec.getRstRcvd();
                break;
            }
            case "RST_SENT": {
                value = rec.getRstSent();
                break;
            }
            case "SOTA_REF": {
                Sota sotaRef = rec.getSotaRef();
                if (sotaRef == null) break;
                value = rec.getSotaRef().getValue();
                break;
            }
            case "MY_SOTA_REF": {
                Sota mySotaRef = rec.getMySotaRef();
                if (mySotaRef == null || "G/LD-999".equalsIgnoreCase(mySotaRef.getValue())) break;
                value = rec.getMySotaRef().getValue();
                break;
            }
            case "NAME": {
                value = rec.getName();
                break;
            }
            case "FIRSTNAME": {
                String[] names = StringUtils.split((String)rec.getName());
                if (names == null || names.length <= 0 || !FIRSTNAME_SKIP.contains(value = names[0]) || names.length <= 1) break;
                value = names[1];
                break;
            }
            case "QTH": {
                value = rec.getQth();
                break;
            }
            case "GRIDSQUARE": {
                if (rec.getGridsquare() == null) break;
                value = this.getNonDubiousGridsquareOptExt(rec);
                break;
            }
            case "COUNTRY": {
                value = rec.getCountry();
                break;
            }
            case "COMMENT": {
                value = rec.getComment();
                break;
            }
            case "DISTANCE": {
                if (rec.getDistance() == null) break;
                Double dist = rec.getDistance();
                value = String.format(column.getFormat(), dist);
                break;
            }
            case "SRX": {
                if (rec.getSrx() != null) {
                    value = String.format(column.getFormat(), rec.getSrx());
                    break;
                }
                if (rec.getSrxString() == null) break;
                value = rec.getSrxString();
                break;
            }
            case "STX": {
                if (rec.getStx() != null) {
                    value = String.format(column.getFormat(), rec.getStx());
                    break;
                }
                if (rec.getStxString() == null) break;
                value = rec.getStxString();
                break;
            }
            case "SIG": {
                if (rec.getSig() != null) {
                    value = rec.getSig();
                    break;
                }
                if (rec.getSotaRef() != null) {
                    value = "SOTA";
                    break;
                }
                if (rec.getWwffRef() != null) {
                    value = "WWFF";
                    break;
                }
                if (rec.getPotaRef() == null) break;
                value = "POTA";
                break;
            }
            case "SIG_INFO": {
                value = this.getActivityInfo(qso.getTo().getActivities(), markdown);
                break;
            }
            case "QSL_STATUS": {
                boolean sent = rec.getQslSDate() != null;
                boolean recvd = rec.getQslRDate() != null;
                Boolean bureau = null;
                Boolean direct = null;
                if (rec.getQslVia() != null) {
                    bureau = rec.getQslVia().toLowerCase(Locale.ROOT).contains("bureau");
                    direct = rec.getQslVia().toLowerCase(Locale.ROOT).contains("direct");
                }
                if (sent && recvd) {
                    value = "SR";
                    break;
                }
                if (sent) {
                    value = "S ";
                    break;
                }
                if (recvd) {
                    value = " R";
                    break;
                }
                if (Boolean.TRUE.equals(bureau) && Boolean.TRUE.equals(direct)) {
                    value = "BD";
                    break;
                }
                if (Boolean.TRUE.equals(bureau)) {
                    value = " B";
                    break;
                }
                if (Boolean.TRUE.equals(direct)) {
                    value = " D";
                    break;
                }
                value = "  ";
                break;
            }
            case "BEARING": {
                Double bearing = GeodesicUtils.getBearing(rec.getMyCoordinates(), rec.getCoordinates());
                if (bearing != null) {
                    value = String.format("%03.0f", bearing);
                }
            }
            default: {
                logger.warning(String.format("Print formatting column %s not currently handled", column.getAdif()));
            }
        }
        return value;
    }

    private String getNonDubiousGridsquareOptExt(Adif3Record rec) {
        Object value = rec.getGridsquare().toUpperCase();
        if (MaidenheadLocatorConversion.isADubiousGridSquare((String)value)) {
            value = "";
        } else if (rec.getGridsquareExt() != null) {
            value = (String)value + rec.getGridsquareExt().toUpperCase();
        }
        return value;
    }

    private String getActivityInfo(Collection<Activity> activities, boolean markdown) {
        String value = "";
        if (activities != null && !activities.isEmpty()) {
            Activity activity = activities.iterator().next();
            value = markdown && StringUtils.isNotEmpty((CharSequence)activity.getUrl()) ? String.format("[%s](%s)", activity.getRef(), activity.getUrl()) : activity.getRef();
        }
        return value;
    }

    public PrintJobConfig getPrintJobConfig() {
        return this.printJobConfig;
    }

    static class PrintState {
        StringBuilder sb;
        int currentPage;
        int currentLine;
        int currentColumn;
        int currentRecord;

        PrintState() {
        }
    }
}

