/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.print;

import com.amihaiemil.eoyaml.Yaml;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Logger;
import uk.m0nom.adifproc.adif3.print.ColumnConfig;
import uk.m0nom.adifproc.adif3.print.LineConfig;
import uk.m0nom.adifproc.adif3.print.PageConfig;
import uk.m0nom.adifproc.adif3.print.PrintUtils;

public class PrintJobConfig {
    private static final Logger logger = Logger.getLogger(PrintJobConfig.class.getName());
    String filename;
    String name;
    String inEncoding;
    String outEncoding;
    String startCommand;
    String endCommand;
    String filenameExtension;
    PageConfig pageConfig;

    public void configure(String filename, InputStream yamlConfig) throws IOException {
        this.filename = filename;
        YamlMapping config = Yaml.createYamlInput((InputStream)yamlConfig).readYamlMapping();
        YamlMapping printJob = config.yamlMapping("printJob");
        this.setName(printJob.string("name"));
        this.setInEncoding(printJob.string("inEncoding"));
        this.setOutEncoding(printJob.string("outEncoding"));
        this.setStartCommand(printJob.string("startCommand"));
        this.setEndCommand(printJob.string("endCommand"));
        this.setFilenameExtension(printJob.string("filenameExtension"));
        YamlMapping page = config.yamlMapping("page");
        this.pageConfig = new PageConfig();
        this.setPageConfig(this.pageConfig);
        this.pageConfig.setPageHeight(page.integer("pageHeight"));
        this.pageConfig.setPageWidth(page.integer("pageWidth"));
        this.pageConfig.setTopMargin(page.integer("topMargin"));
        this.pageConfig.setBottomMargin(page.integer("bottomMargin"));
        this.pageConfig.setLeftMargin(page.integer("leftMargin"));
        this.pageConfig.setRightMargin(page.integer("rightMargin"));
        this.pageConfig.setPageEnd(PrintUtils.stripQuotes(page.string("pageEnd")));
        this.pageConfig.setLineEnd(PrintUtils.stripQuotes(page.string("lineEnd")));
        this.pageConfig.setHeaderLine(PrintUtils.stripQuotes(page.string("headerLine")));
        this.pageConfig.setColumnSeparator(PrintUtils.stripQuotes(page.string("columnSeparator")));
        this.pageConfig.setHeaderSeparator(PrintUtils.stripQuotes(page.string("headerSeparator")));
        LineConfig line = new LineConfig();
        this.pageConfig.setLine(line);
        Collection nodes = config.yamlSequence("columns").values();
        for (YamlNode node : nodes) {
            ColumnConfig column = new ColumnConfig();
            YamlMapping colMap = node.asMapping().yamlMapping("column");
            column.setAdif(colMap.string("adif"));
            column.setHeader(colMap.string("header"));
            column.setStart(colMap.integer("start"));
            column.setLength(colMap.integer("length"));
            column.setAlign(colMap.string("align"));
            column.setFormat(colMap.string("format"));
            line.addColumn(column);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String getName() {
        return this.name;
    }

    public String getInEncoding() {
        return this.inEncoding;
    }

    public String getOutEncoding() {
        return this.outEncoding;
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public String getEndCommand() {
        return this.endCommand;
    }

    public String getFilenameExtension() {
        return this.filenameExtension;
    }

    public PageConfig getPageConfig() {
        return this.pageConfig;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInEncoding(String inEncoding) {
        this.inEncoding = inEncoding;
    }

    public void setOutEncoding(String outEncoding) {
        this.outEncoding = outEncoding;
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    public void setEndCommand(String endCommand) {
        this.endCommand = endCommand;
    }

    public void setFilenameExtension(String filenameExtension) {
        this.filenameExtension = filenameExtension;
    }

    public void setPageConfig(PageConfig pageConfig) {
        this.pageConfig = pageConfig;
    }
}

