/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.transform;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.Band;
import org.marsik.ham.adif.enums.Propagation;
import org.marsik.ham.adif.types.Pota;
import org.marsik.ham.adif.types.PotaList;
import org.marsik.ham.adif.types.Sota;
import org.marsik.ham.adif.types.Wwff;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityDatabase;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.contacts.Qsos;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.adif3.transform.ActivityProcessor;
import uk.m0nom.adifproc.adif3.transform.Adif3RecordTransformer;
import uk.m0nom.adifproc.adif3.transform.AdifQrzEnricher;
import uk.m0nom.adifproc.adif3.transform.SotaMicrowaveAward;
import uk.m0nom.adifproc.adif3.transform.TransformResults;
import uk.m0nom.adifproc.adif3.transform.comment.CommentTransformer;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationSource;
import uk.m0nom.adifproc.geocoding.GeocodingProvider;
import uk.m0nom.adifproc.geocoding.GeocodingResult;
import uk.m0nom.adifproc.location.FromLocationDeterminer;
import uk.m0nom.adifproc.location.ToLocationDeterminer;
import uk.m0nom.adifproc.maidenheadlocator.MaidenheadLocatorConversion;
import uk.m0nom.adifproc.qrz.CachingQrzXmlService;
import uk.m0nom.adifproc.qrz.QrzCallsign;
import uk.m0nom.adifproc.satellite.ApSatellite;
import uk.m0nom.adifproc.satellite.ApSatelliteService;

@Service
public class CommentParsingAdifRecordTransformer
implements Adif3RecordTransformer {
    private static final Logger logger = Logger.getLogger(CommentParsingAdifRecordTransformer.class.getName());
    private final ActivityDatabaseService activities;
    private final CachingQrzXmlService qrzXmlService;
    private final AdifQrzEnricher enricher;
    private final FromLocationDeterminer fromLocationDeterminer;
    private final ToLocationDeterminer toLocationDeterminer;
    private final ActivityProcessor activityProcessor;
    private final GeocodingProvider geocodingProvider;
    private final CommentTransformer fieldParserCommentTransformer;
    private final CommentTransformer schemaBasedCommentTransformer;
    private final ApSatelliteService apSatelliteService;

    private void processSotaRef(Qso qso, TransformResults results) {
        Adif3Record rec = qso.getRecord();
        if (rec.getSotaRef() != null && StringUtils.isNotBlank((CharSequence)rec.getSotaRef().getValue())) {
            String sotaId = rec.getSotaRef().getValue();
            Activity activity = this.activities.getDatabase(ActivityType.SOTA).get(sotaId);
            if (activity != null) {
                qso.getTo().addActivity(activity);
                String result = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.SOTA, sotaId);
                if (result != null) {
                    results.addContactWithDubiousLocation(result);
                }
            } else {
                results.addContactWithDubiousLocation(String.format("%s (SOTA %s invalid)", qso.getTo().getCallsign(), sotaId));
            }
        }
    }

    private void processWwffRef(Qso qso, TransformResults results) {
        Adif3Record rec = qso.getRecord();
        if (rec.getWwffRef() != null && StringUtils.isNotBlank((CharSequence)rec.getWwffRef().getValue())) {
            String wwffId = rec.getWwffRef().getValue();
            Activity activity = this.activities.getDatabase(ActivityType.WWFF).get(wwffId);
            if (activity != null) {
                qso.getTo().addActivity(activity);
                String result = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.WWFF, wwffId);
                if (result != null) {
                    results.addContactWithDubiousLocation(result);
                }
            } else {
                results.addContactWithDubiousLocation(String.format("%s (WWFF %s invalid)", qso.getTo().getCallsign(), wwffId));
            }
        }
    }

    private void processPotaRefs(Qso qso, TransformResults results) {
        boolean locationSet = false;
        Adif3Record rec = qso.getRecord();
        if (rec.getPotaRef() != null && StringUtils.isNotBlank((CharSequence)rec.getPotaRef().getValue())) {
            PotaList potaIds = rec.getPotaRef();
            for (Pota potaId : potaIds.getPotaList()) {
                Activity activity = this.activities.getDatabase(ActivityType.POTA).get(potaId.getValue());
                if (activity != null) {
                    qso.getTo().addActivity(activity);
                    if (locationSet) continue;
                    String result = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.POTA, potaId.getValue());
                    if (result != null) {
                        results.addContactWithDubiousLocation(result);
                        continue;
                    }
                    locationSet = true;
                    continue;
                }
                results.addContactWithDubiousLocation(String.format("%s (POTA %s invalid)", qso.getTo().getCallsign(), potaId.getValue()));
            }
            if (potaIds.getPotaList().size() > 1) {
                results.addContactWithDubiousLocation(String.format("Multiple POTA Ids: %s, using last ref as location", potaIds.getValue()));
            }
        }
    }

    private void processRailwaysOnTheAirCallsign(Qso qso, TransformResults results) {
        Adif3Record rec = qso.getRecord();
        Activity rotaInfo = this.activities.getDatabase(ActivityType.ROTA).get(rec.getCall().toUpperCase());
        if (rotaInfo != null) {
            String result = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.ROTA, rotaInfo.getRef());
            if (result != null) {
                results.addContactWithDubiousLocation(result);
            }
            qso.getTo().addActivity(rotaInfo);
        }
    }

    private void setMyInfoFromQrz(TransformControl control, Qso qso) {
        QrzCallsign myQrzData = this.qrzXmlService.getCallsignData(qso.getRecord().getStationCallsign());
        this.fromLocationDeterminer.setMyLocation(control, qso, myQrzData);
        qso.getFrom().setQrzInfo(myQrzData);
        this.enricher.enrichAdifForMe(qso.getRecord(), myQrzData);
    }

    private QrzCallsign setTheirInfoFromQrz(Qso qso) {
        QrzCallsign theirQrzData = this.qrzXmlService.getCallsignData(qso.getTo().getCallsign());
        qso.getTo().setQrzInfo(theirQrzData);
        this.enricher.enrichAdifForThem(qso.getRecord(), theirQrzData);
        return theirQrzData;
    }

    private void processSatelliteInfo(TransformControl control, Qso qso) {
        Adif3Record rec = qso.getRecord();
        if (StringUtils.isBlank((CharSequence)control.getSatelliteBand()) || rec.getBand() == Band.findByCode(control.getSatelliteBand().toLowerCase())) {
            if (StringUtils.isNotBlank((CharSequence)control.getSatelliteMode())) {
                rec.setSatMode(control.getSatelliteMode().toUpperCase());
            }
            if (StringUtils.isNotBlank((CharSequence)control.getSatelliteName())) {
                rec.setSatName(control.getSatelliteName().toUpperCase());
            }
            if (StringUtils.isNotBlank((CharSequence)rec.getSatName())) {
                rec.setPropMode(Propagation.SATELLITE);
            }
        }
    }

    private boolean hasValidGridSquareNoCoords(Adif3Record rec) {
        return rec.getCoordinates() == null && rec.getGridsquare() != null && !MaidenheadLocatorConversion.isADubiousGridSquare(rec.getGridsquare());
    }

    private boolean setCoordinatesFromGridSquare(Qso qso) {
        Adif3Record rec = qso.getRecord();
        try {
            GlobalCoords3D coords = MaidenheadLocatorConversion.locatorToCoords(LocationSource.OVERRIDE, rec.getGridsquare(), rec.getGridsquareExt());
            rec.setCoordinates(coords);
            qso.getTo().setCoordinates(coords);
            qso.getTo().setGrid(rec.getGridsquare());
        }
        catch (UnsupportedOperationException e) {
            logger.warning(String.format("For QSO with %s: %s", qso.getTo().getCallsign(), e.getMessage()));
            return false;
        }
        return true;
    }

    private boolean hasNoValidGridSquareOrCoords(Adif3Record rec) {
        return rec.getCoordinates() == null || MaidenheadLocatorConversion.isADubiousGridSquare(rec.getGridsquare());
    }

    private boolean hasValidCoords(Adif3Record rec) {
        return rec.getCoordinates() != null;
    }

    private void setTheirLocationFromSuppliedCoords(Qso qso, Adif3Record rec) {
        qso.getTo().setCoordinates(new GlobalCoords3D(rec.getCoordinates(), LocationSource.FROM_ADIF, LocationAccuracy.LAT_LONG));
        if (MaidenheadLocatorConversion.isEmptyOrInvalid(rec.getGridsquare())) {
            rec.setGridsquare(MaidenheadLocatorConversion.coordsToLocator(rec.getCoordinates()));
        }
    }

    private void setTheirLocationFromGeocodedAddress(Qso qso, QrzCallsign theirQrzData) {
        Adif3Record rec = qso.getRecord();
        try {
            GeocodingResult result = this.geocodingProvider.getLocationFromAddress(theirQrzData);
            rec.setCoordinates(result.getCoordinates());
            qso.getTo().setCoordinates(result.getCoordinates());
            if (rec.getCoordinates() != null) {
                logger.info(String.format("Location for %s set based on geolocation data to: %s", rec.getCall(), rec.getCoordinates()));
                if (MaidenheadLocatorConversion.isEmptyOrInvalid(rec.getGridsquare())) {
                    rec.setGridsquare(MaidenheadLocatorConversion.coordsToLocator(rec.getCoordinates()));
                }
            }
        }
        catch (Exception e) {
            logger.severe(String.format("Caught Exception from Geolocation Provider looking up %s: %s", rec.getCall(), e.getMessage()));
        }
    }

    private boolean coordsAreZero(GlobalCoordinates coords) {
        return coords.getLatitude() == 0.0 && coords.getLongitude() == 0.0;
    }

    private void nullCoordsIfZero(Adif3Record rec) {
        if (rec.getCoordinates() != null && this.coordsAreZero(rec.getCoordinates())) {
            rec.setCoordinates(null);
        }
        if (rec.getMyCoordinates() != null && this.coordsAreZero(rec.getMyCoordinates())) {
            rec.setMyCoordinates(null);
        }
    }

    @Override
    public void transform(TransformControl control, TransformResults results, Qsos qsos, Adif3Record rec, int index) {
        ZonedDateTime date;
        HashMap<String, String> unmapped = new HashMap<String, String>();
        results.getSatelliteActivity().setSatellites(this.apSatelliteService);
        this.nullCoordsIfZero(rec);
        Qso qso = new Qso(rec, index);
        qsos.addQso(qso);
        this.activityProcessor.processActivities(control, qso.getFrom(), rec);
        qso.getFrom().setAntenna(control.getAntenna());
        this.setMyInfoFromQrz(control, qso);
        QrzCallsign theirQrzData = this.setTheirInfoFromQrz(qso);
        this.schemaBasedCommentTransformer.transformComment(qso, rec.getComment(), unmapped, results);
        String remainingComment = this.generateCommentFromUnmapped(unmapped);
        this.fieldParserCommentTransformer.transformComment(qso, remainingComment, unmapped, results);
        this.processSotaRef(qso, results);
        this.processWwffRef(qso, results);
        this.processPotaRefs(qso, results);
        this.processRailwaysOnTheAirCallsign(qso, results);
        this.processSatelliteInfo(control, qso);
        if (rec.getCoordinates() == null && rec.getGridsquare() == null) {
            this.enricher.lookupLocationFromQrz(qso);
        }
        if (this.hasValidGridSquareNoCoords(rec) && !this.setCoordinatesFromGridSquare(qso)) {
            results.addContactWithDubiousLocation(String.format("%s (Locator %s invalid)", qso.getTo().getCallsign(), rec.getGridsquare()));
        }
        if (this.hasNoValidGridSquareOrCoords(rec) && theirQrzData != null) {
            this.setTheirLocationFromGeocodedAddress(qso, theirQrzData);
        }
        if (qso.getTo().getCoordinates() == null && this.hasValidCoords(rec)) {
            this.setTheirLocationFromSuppliedCoords(qso, rec);
        }
        this.improveAccuracyOfMyLocationIfRequired(qso);
        if (StringUtils.isNotBlank((CharSequence)rec.getSig())) {
            this.processSig(qso);
        }
        if (control.isStripComment()) {
            if (!unmapped.isEmpty()) {
                this.addUnmappedToRecord(rec, unmapped);
            } else {
                rec.setComment("");
            }
        }
        if (control.isSotaMicrowaveAwardComment()) {
            SotaMicrowaveAward.addSotaMicrowaveAwardToComment(rec);
        }
        if (rec.getSatName() != null) {
            if (this.apSatelliteService.isAKnownSatellite(rec.getSatName())) {
                ApSatellite satellite = this.apSatelliteService.getSatellite(rec.getSatName());
                if (satellite.isGeostationary() || this.apSatelliteService.getEarliestDataAvailable().isBefore(rec.getQsoDate())) {
                    results.getSatelliteActivity().recordSatelliteActivity(qso);
                } else {
                    results.addUnknownSatellitePass(String.format("%s: %s", rec.getSatName(), rec.getQsoDate()));
                }
            } else {
                results.addUnknownSatellite(rec.getSatName());
            }
        }
        if (rec.getMyAltitude() != null) {
            double alt = rec.getMyAltitude();
            if (qso.getFrom().getCoordinates() != null) {
                qso.getFrom().getCoordinates().setAltitude(alt);
            }
        }
        if (rec.getAltitude() != null) {
            double alt = rec.getAltitude();
            if (qso.getTo().getCoordinates() != null) {
                qso.getTo().getCoordinates().setAltitude(alt);
            }
        }
        if ((date = qso.getRecord().getQsoDate()) != null) {
            control.getDxccEntities().setFromDxccEntity(qso, control);
            control.getDxccEntities().setToDxccEntity(qso, control);
        } else {
            results.addWarning(String.format("Record %d with station %s has no date", index, qso.getTo().getCallsign()));
        }
        this.checkForWarnings(results, qso);
    }

    private void checkForWarnings(TransformResults results, Qso qso) {
        QrzCallsign qrzInfo = qso.getTo().getQrzInfo();
        Adif3Record rec = qso.getRecord();
        if (qrzInfo != null) {
            if (rec.getName() != null && qrzInfo.getName() != null) {
                String displayQrzName = AdifQrzEnricher.getNameFromQrzData(qrzInfo);
                if (!StringUtils.equalsIgnoreCase((CharSequence)rec.getName(), (CharSequence)displayQrzName) && !StringUtils.containsIgnoreCase((CharSequence)displayQrzName, (CharSequence)rec.getName())) {
                    results.addWarning(String.format("Check name for %s: provided is '%s', QRZ has '%s'", rec.getCall(), rec.getName(), displayQrzName));
                }
            }
            if (rec.getState() != null && qrzInfo.getState() != null && !qso.getTo().hasActivity() && !StringUtils.equalsIgnoreCase((CharSequence)rec.getState(), (CharSequence)qrzInfo.getState())) {
                results.addWarning(String.format("Check state for %s: provided is %s, QRZ has %s", rec.getCall(), rec.getState().toUpperCase(), qrzInfo.getState().toUpperCase()));
            }
        }
    }

    private void improveAccuracyOfMyLocationIfRequired(Qso qso) {
        QrzCallsign myQrzInfo;
        if (qso.getFrom().getQrzInfo() != null && (myQrzInfo = qso.getFrom().getQrzInfo()).getGrid() != null) {
            String myQrzGrid = myQrzInfo.getGrid();
            String myQsoGrid = qso.getFrom().getGrid();
            if (myQrzGrid != null && myQsoGrid != null && myQrzGrid.length() > myQsoGrid.length()) {
                if (myQrzGrid.startsWith(myQsoGrid)) {
                    GlobalCoords3D coords = MaidenheadLocatorConversion.locatorToCoords(LocationSource.QRZ, myQrzGrid, null);
                    qso.getFrom().setCoordinates(coords);
                    qso.getRecord().setMyCoordinates(coords);
                }
            } else if (myQrzGrid != null && myQsoGrid == null) {
                GlobalCoords3D coords = MaidenheadLocatorConversion.locatorToCoords(LocationSource.QRZ, myQrzGrid, null);
                qso.getFrom().setCoordinates(coords);
                qso.getRecord().setMyCoordinates(coords);
            }
        }
    }

    private void processSig(Qso qso) {
        Activity activity;
        ActivityDatabase database;
        Adif3Record rec = qso.getRecord();
        String activityType = rec.getSig().toUpperCase();
        String activityLocation = rec.getSigInfo().toUpperCase();
        if (StringUtils.isNotBlank((CharSequence)activityType) && (database = this.activities.getDatabase(activityType)) != null && (activity = database.get(activityLocation)) != null) {
            boolean potaFieldEmpty;
            qso.getTo().addActivity(activity);
            boolean sotaFieldEmpty = rec.getSotaRef() == null || StringUtils.isBlank((CharSequence)rec.getSotaRef().getValue());
            boolean wwffFieldEmpty = rec.getWwffRef() == null || StringUtils.isBlank((CharSequence)rec.getWwffRef().getValue());
            boolean bl = potaFieldEmpty = rec.getPotaRef() == null || StringUtils.isBlank((CharSequence)rec.getPotaRef().getValue());
            if (sotaFieldEmpty && wwffFieldEmpty && potaFieldEmpty) {
                this.toLocationDeterminer.setTheirLocationFromActivity(qso, activity);
            }
            if (sotaFieldEmpty && activity.getType() == ActivityType.SOTA) {
                rec.setSotaRef(Sota.valueOf(activity.getRef()));
                this.clearSigAndSigInfo(rec);
            }
            if (wwffFieldEmpty && activity.getType() == ActivityType.WWFF) {
                rec.setWwffRef(Wwff.valueOf(activity.getRef()));
                this.clearSigAndSigInfo(rec);
            }
            if (potaFieldEmpty && activity.getType() == ActivityType.POTA) {
                rec.setPotaRef(PotaList.valueOf(activity.getRef()));
                this.clearSigAndSigInfo(rec);
            }
        }
    }

    private void clearSigAndSigInfo(Adif3Record rec) {
        rec.setSig(null);
        rec.setSigInfo(null);
    }

    private void addUnmappedToRecord(Adif3Record rec, Map<String, String> unmapped) {
        StringBuilder sb = new StringBuilder();
        Set<String> keySet = unmapped.keySet();
        int keySetLen = keySet.size();
        int i = 1;
        for (String key : unmapped.keySet()) {
            if (StringUtils.isNotEmpty((CharSequence)key)) {
                sb.append(String.format("%s: %s", key, unmapped.get(key)));
                if (i++ >= keySetLen) continue;
                sb.append(", ");
                continue;
            }
            sb.append(String.format("%s ", key));
        }
        rec.setComment(sb.toString());
    }

    private String generateCommentFromUnmapped(Map<String, String> unmapped) {
        StringBuilder sb = new StringBuilder();
        for (String key : unmapped.keySet()) {
            sb.append(String.format("%s: %s ", key, unmapped.get(key)));
        }
        return sb.toString();
    }

    public CommentParsingAdifRecordTransformer(ActivityDatabaseService activities, CachingQrzXmlService qrzXmlService, AdifQrzEnricher enricher, FromLocationDeterminer fromLocationDeterminer, ToLocationDeterminer toLocationDeterminer, ActivityProcessor activityProcessor, GeocodingProvider geocodingProvider, CommentTransformer fieldParserCommentTransformer, CommentTransformer schemaBasedCommentTransformer, ApSatelliteService apSatelliteService) {
        this.activities = activities;
        this.qrzXmlService = qrzXmlService;
        this.enricher = enricher;
        this.fromLocationDeterminer = fromLocationDeterminer;
        this.toLocationDeterminer = toLocationDeterminer;
        this.activityProcessor = activityProcessor;
        this.geocodingProvider = geocodingProvider;
        this.fieldParserCommentTransformer = fieldParserCommentTransformer;
        this.schemaBasedCommentTransformer = schemaBasedCommentTransformer;
        this.apSatelliteService = apSatelliteService;
    }
}

