/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.transform.comment.parsers;

import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.types.Wwff;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.CommentFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.CommentFieldParserException;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.FieldParseResult;
import uk.m0nom.adifproc.location.ToLocationDeterminer;

public class WwffFieldParser
implements CommentFieldParser {
    private final ToLocationDeterminer toLocationDeterminer;

    public WwffFieldParser(ToLocationDeterminer toLocationDeterminer, ActivityDatabaseService activities) {
        this.toLocationDeterminer = toLocationDeterminer;
    }

    @Override
    public FieldParseResult parseField(String value, Qso qso) throws CommentFieldParserException {
        FieldParseResult result;
        Adif3Record rec = qso.getRecord();
        String wwffRef = StringUtils.split((String)value, (char)' ')[0];
        try {
            Wwff wwff = Wwff.valueOf(wwffRef.toUpperCase());
            rec.setWwffRef(wwff);
            String invalidCallSign = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.WWFF, wwffRef);
            result = new FieldParseResult(invalidCallSign, false);
        }
        catch (IllegalArgumentException iae) {
            throw new CommentFieldParserException(this.getClass().getName(), "notValidActivityRef", qso, (Exception)iae, true, value, rec.getCall(), rec.getTimeOn().toString());
        }
        return result;
    }
}

