/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.xsdquery;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3Field;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3Schema;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3Type;

public class Adif3SchemaLoader {
    private static final Logger logger = Logger.getLogger(Adif3SchemaLoader.class.getName());
    private static final List<String> UNSUPPORTED_FIELDS = Arrays.asList("APP", "USERDEF");

    public static Adif3Schema loadFromFile(String filename) throws FileNotFoundException {
        FileInputStream fileIS = new FileInputStream(filename);
        return Adif3SchemaLoader.loadAdif3Schema(fileIS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Adif3Schema loadAdif3Schema(InputStream stream) {
        Adif3Schema schema;
        block10: {
            schema = new Adif3Schema();
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(stream);
            Adif3SchemaLoader.parseTypes(schema, xmlDocument);
            Adif3SchemaLoader.parseFields(schema, xmlDocument);
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.severe(String.format("Exception %s generated on schema close", e.getMessage()));
            }
            break block10;
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                Adif3Schema adif3Schema;
                try {
                    logger.severe(String.format("Exception %s generated loading schema", e.getMessage()));
                    adif3Schema = null;
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        logger.severe(String.format("Exception %s generated on schema close", e2.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException e3) {
                    logger.severe(String.format("Exception %s generated on schema close", e3.getMessage()));
                }
                return adif3Schema;
            }
        }
        return schema;
    }

    private static void parseTypes(Adif3Schema schema, Document xmlDocument) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String expression = "/schema/simpleType";
        NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(xmlDocument, XPathConstants.NODESET);
        schema.setTypes(Adif3SchemaLoader.getTypesFromNodeList(nodeList));
    }

    private static void parseFields(Adif3Schema schema, Document xmlDocument) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String expression = "/schema/element[@name='ADX']/complexType/sequence/element[@name='RECORDS']/complexType/sequence/element[@name='RECORD']/complexType/choice/element";
        NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(xmlDocument, XPathConstants.NODESET);
        Adif3SchemaLoader.setFieldsFromNodeList(schema, nodeList);
    }

    private static void setFieldsFromNodeList(Adif3Schema schema, NodeList nodes) {
        HashSet<Adif3Field> elements = new HashSet<Adif3Field>();
        for (int n = nodes.getLength() - 1; n >= 0; --n) {
            String nillableAttr;
            Element e;
            String name;
            Node child = nodes.item(n);
            short nodeType = child.getNodeType();
            if (nodeType != 1 || UNSUPPORTED_FIELDS.contains(name = (e = (Element)child).getAttribute("name"))) continue;
            String type = e.getAttribute("type");
            Boolean nillable = null;
            switch (nillableAttr = e.getAttribute("nillable")) {
                case "true": {
                    nillable = Boolean.TRUE;
                    break;
                }
                case "false": {
                    nillable = Boolean.FALSE;
                }
            }
            Adif3Field field = new Adif3Field(name, schema.getType(type), nillable);
            elements.add(field);
            if (!child.hasChildNodes()) continue;
            Adif3SchemaLoader.setFieldSpecificType(schema, field, child.getChildNodes());
        }
        schema.setFields(elements);
    }

    private static void setFieldSpecificType(Adif3Schema schema, Adif3Field field, NodeList nodes) {
        for (int n = nodes.getLength() - 1; n >= 0; --n) {
            Node child = nodes.item(n);
            if (!"xs:simpleType".equals(child.getNodeName())) continue;
            Adif3Type fieldSpecificType = Adif3SchemaLoader.parseTypeNode(child);
            fieldSpecificType.setName(field.getName());
            schema.addType(fieldSpecificType);
            field.setType(fieldSpecificType);
        }
    }

    private static Set<Adif3Type> getTypesFromNodeList(NodeList nodes) {
        HashSet<Adif3Type> types = new HashSet<Adif3Type>();
        for (int n = nodes.getLength() - 1; n >= 0; --n) {
            Node child = nodes.item(n);
            if (!"xs:simpleType".equals(child.getNodeName())) continue;
            types.add(Adif3SchemaLoader.parseTypeNode(child));
        }
        return types;
    }

    private static Adif3Type parseTypeNode(Node typeNode) {
        Adif3Type type = new Adif3Type();
        if (typeNode.getAttributes().getNamedItem("name") != null) {
            type.setName(typeNode.getAttributes().getNamedItem("name").getNodeValue());
        }
        NodeList nodes = typeNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            if (!child.getNodeName().equals("xs:restriction")) continue;
            Adif3SchemaLoader.parseTypeNodeRestriction(type, child);
        }
        return type;
    }

    private static void parseTypeNodeRestriction(Adif3Type type, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node baseType = attributes.getNamedItem("base");
        if (baseType != null) {
            type.setBaseType(baseType.getNodeValue());
            if (node.getChildNodes().getLength() > 0) {
                Adif3SchemaLoader.parseTypeNodeRestrictionOptions(type, node.getChildNodes());
            }
        }
    }

    private static void parseTypeNodeRestrictionOptions(Adif3Type type, NodeList options) {
        block12: for (int i = 0; i < options.getLength(); ++i) {
            Node child = options.item(i);
            switch (child.getNodeName()) {
                case "xs:pattern": {
                    type.setRegex(Pattern.compile(child.getAttributes().getNamedItem("value").getNodeValue()));
                    continue block12;
                }
                case "xs:whiteSpace": {
                    type.setPreserveWhiteSpace("preserve".equals(Adif3SchemaLoader.getAttributeValue(child)));
                    continue block12;
                }
                case "xs:minInclusive": {
                    type.setMinInclusive(Integer.parseInt(Adif3SchemaLoader.getAttributeValue(child)));
                    continue block12;
                }
                case "xs:maxInclusive": {
                    type.setMaxInclusive(Integer.parseInt(Adif3SchemaLoader.getAttributeValue(child)));
                }
            }
        }
    }

    private static String getAttributeValue(Node node) {
        return node.getAttributes().getNamedItem("value").getNodeValue();
    }
}

