/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.comms;

import java.util.ArrayList;
import java.util.List;
import org.marsik.ham.adif.enums.Propagation;
import uk.m0nom.adifproc.comms.PropagationApex;
import uk.m0nom.adifproc.coords.GlobalCoords3D;

public class CommsLinkResult {
    private GlobalCoords3D start;
    private GlobalCoords3D end;
    private int bounces;
    private double altitude;
    private double base;
    private double distanceInKm;
    private double fromAngle;
    private double toAngle;
    private double skyDistance;
    private Propagation propagation;
    private double azimuth;
    private List<PropagationApex> apexes;
    private List<GlobalCoords3D> path;
    private GlobalCoords3D satellitePosition;
    private String error = null;
    private String unknownSatellite = null;
    private boolean unknownSatellitePass = false;
    private boolean unsupportedPropagationMode = false;
    private Propagation unsupportedPropagation;

    public CommsLinkResult() {
        this.path = new ArrayList<GlobalCoords3D>();
    }

    public CommsLinkResult(String error) {
        this.error = error;
    }

    public CommsLinkResult(GlobalCoords3D start, GlobalCoords3D end) {
        this();
        this.start = start;
        this.end = end;
    }

    public boolean isValid() {
        return this.error == null && this.unknownSatellite == null && !this.unknownSatellitePass;
    }

    public GlobalCoords3D getStart() {
        return this.start;
    }

    public GlobalCoords3D getEnd() {
        return this.end;
    }

    public int getBounces() {
        return this.bounces;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public double getBase() {
        return this.base;
    }

    public double getDistanceInKm() {
        return this.distanceInKm;
    }

    public double getFromAngle() {
        return this.fromAngle;
    }

    public double getToAngle() {
        return this.toAngle;
    }

    public double getSkyDistance() {
        return this.skyDistance;
    }

    public Propagation getPropagation() {
        return this.propagation;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public List<PropagationApex> getApexes() {
        return this.apexes;
    }

    public List<GlobalCoords3D> getPath() {
        return this.path;
    }

    public GlobalCoords3D getSatellitePosition() {
        return this.satellitePosition;
    }

    public String getError() {
        return this.error;
    }

    public String getUnknownSatellite() {
        return this.unknownSatellite;
    }

    public boolean isUnknownSatellitePass() {
        return this.unknownSatellitePass;
    }

    public boolean isUnsupportedPropagationMode() {
        return this.unsupportedPropagationMode;
    }

    public Propagation getUnsupportedPropagation() {
        return this.unsupportedPropagation;
    }

    public void setStart(GlobalCoords3D start) {
        this.start = start;
    }

    public void setEnd(GlobalCoords3D end) {
        this.end = end;
    }

    public void setBounces(int bounces) {
        this.bounces = bounces;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public void setBase(double base) {
        this.base = base;
    }

    public void setDistanceInKm(double distanceInKm) {
        this.distanceInKm = distanceInKm;
    }

    public void setFromAngle(double fromAngle) {
        this.fromAngle = fromAngle;
    }

    public void setToAngle(double toAngle) {
        this.toAngle = toAngle;
    }

    public void setSkyDistance(double skyDistance) {
        this.skyDistance = skyDistance;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public void setAzimuth(double azimuth) {
        this.azimuth = azimuth;
    }

    public void setApexes(List<PropagationApex> apexes) {
        this.apexes = apexes;
    }

    public void setPath(List<GlobalCoords3D> path) {
        this.path = path;
    }

    public void setSatellitePosition(GlobalCoords3D satellitePosition) {
        this.satellitePosition = satellitePosition;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setUnknownSatellite(String unknownSatellite) {
        this.unknownSatellite = unknownSatellite;
    }

    public void setUnknownSatellitePass(boolean unknownSatellitePass) {
        this.unknownSatellitePass = unknownSatellitePass;
    }

    public void setUnsupportedPropagationMode(boolean unsupportedPropagationMode) {
        this.unsupportedPropagationMode = unsupportedPropagationMode;
    }

    public void setUnsupportedPropagation(Propagation unsupportedPropagation) {
        this.unsupportedPropagation = unsupportedPropagation;
    }
}

