/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.comms;

import java.util.LinkedList;
import java.util.List;
import org.marsik.ham.adif.enums.Propagation;
import uk.m0nom.adifproc.comms.PropagationApex;

public class Troposphere {
    public static final double DUCT_ALTITUDE = 2000.0;
    public static final double DUCT_SIZE = 500.0;

    private double metersFromKm(double kms) {
        return kms * 1000.0;
    }

    public List<PropagationApex> getBounces(double distanceInKm) {
        LinkedList<PropagationApex> bounces = new LinkedList<PropagationApex>();
        double topOfDuctAlt = 2250.0;
        double bottomOfDuctAlt = 1750.0;
        int hops = this.calculateNumberOfDuctBounces(this.metersFromKm(distanceInKm));
        double hopDistance = distanceInKm / (double)hops;
        for (int i = 0; i < hops; ++i) {
            PropagationApex bounce = new PropagationApex(Propagation.TROPOSPHERIC_DUCTING, hopDistance, topOfDuctAlt, topOfDuctAlt, bottomOfDuctAlt, 0.0);
            bounces.add(bounce);
        }
        return bounces;
    }

    private int calculateNumberOfDuctBounces(double distance) {
        return (int)Math.floor(distance / 500.0 / 16.0) + 1;
    }
}

