/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.comms.ionosphere;

import java.time.LocalTime;
import java.util.List;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.Propagation;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.comms.CommsLinkResult;
import uk.m0nom.adifproc.comms.PropagationApex;
import uk.m0nom.adifproc.comms.PropagationUtils;
import uk.m0nom.adifproc.comms.ionosphere.Ionosphere;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.geodesic.GeodesicUtils;

public class IonosphereUtils {
    private static final LocalTime MIDDAY = LocalTime.of(12, 0);

    private static LocalTime getTime(Adif3Record rec) {
        LocalTime time = MIDDAY;
        if (rec.getTimeOn() != null) {
            time = rec.getTimeOn();
        }
        return time;
    }

    private static double getFrequency(Adif3Record rec) {
        double frequencyInKhz = 145000.0;
        if (rec.getFreq() != null) {
            frequencyInKhz = rec.getFreq() * 1000.0;
        } else if (rec.getBand() != null) {
            frequencyInKhz = (rec.getBand().getLowerFrequency() + (rec.getBand().getUpperFrequency() - rec.getBand().getLowerFrequency()) / 2.0) * 1000.0;
        }
        return frequencyInKhz;
    }

    public static CommsLinkResult getShortestPath(TransformControl control, GlobalCoords3D start, GlobalCoords3D end, Adif3Record rec) {
        LocalTime time = IonosphereUtils.getTime(rec);
        double frequencyInKhz = IonosphereUtils.getFrequency(rec);
        CommsLinkResult result = PropagationUtils.calculateGeodeticCurve(start, end);
        double azimuth = result.getAzimuth();
        double avgAltitude = 0.0;
        double avgAngle = 0.0;
        Propagation mode = rec.getPropMode();
        List<PropagationApex> apexes = new Ionosphere().getBounces(mode, frequencyInKhz, result.getDistanceInKm(), time, start.getAltitude(), end.getAltitude(), control.getAntenna().getTakeOffAngle());
        double skyDistance = GeodesicUtils.calculatePath(result.getPath(), apexes, start, end, azimuth);
        result.setSkyDistance(skyDistance);
        for (PropagationApex bounce : apexes) {
            avgAltitude += bounce.getApexHeight();
            avgAngle += bounce.getRadiationAngle();
            mode = bounce.getMode();
        }
        result.setApexes(apexes);
        result.setPropagation(mode);
        result.setAltitude(avgAltitude / (double)apexes.size());
        result.setFromAngle(avgAngle / (double)apexes.size());
        result.setBounces(apexes.size());
        return result;
    }

    public static double normaliseAngle(double angle) {
        double result;
        for (result = angle; result < 0.0; result += 360.0) {
        }
        while (result > 360.0) {
            result -= 360.0;
        }
        return result;
    }

    public static double normalisedAngleAddition(double start, double delta) {
        return IonosphereUtils.normaliseAngle(start + delta);
    }
}

