/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.comms.ionosphere;

import org.jetbrains.annotations.NotNull;
import uk.m0nom.adifproc.comms.PropagationApex;

public class IonosphericApexCalculator {
    public static final double R = 6371.0;

    public static PropagationApex calculateDistanceOfApex(double h, double hfAntennaTakeoffAngleInDegrees) {
        double d = IonosphericApexCalculator.calculateDistanceToIonosphere(h, hfAntennaTakeoffAngleInDegrees);
        PropagationApex result = new PropagationApex();
        result.setApexHeight(h);
        result.setDistanceToApex(d);
        result.setRadiationAngle(hfAntennaTakeoffAngleInDegrees);
        double distance = IonosphericApexCalculator.calculateDistanceAcrossEarth(result);
        result.setDistanceAcrossEarth(distance);
        return result;
    }

    public static double calculateTakeoffAngleFromDistanceAcrossEarth(double de, double h) {
        double A = de / 40030.173592041145 * 360.0;
        double b = 6371.0 + h;
        double b2 = Math.pow(b, 2.0);
        double c = 6371.0;
        double c2 = Math.pow(c, 2.0);
        double a2 = b2 + c2 - 2.0 * b * c * Math.cos(Math.toRadians(A));
        double a = Math.sqrt(a2);
        double B = 180.0 - Math.toDegrees(Math.asin(b * Math.sin(Math.toRadians(A)) / a));
        double takeOffAngle = B - 90.0;
        return takeOffAngle;
    }

    public static double calculateDistanceToIonosphere(double h, double hfAntennaTakeoffAngleInDegrees) {
        double B = hfAntennaTakeoffAngleInDegrees + 90.0;
        double c = 6371.0;
        double b = 6371.0 + h;
        double C = Math.toDegrees(Math.asin(c * Math.sin(Math.toRadians(B)) / b));
        double A = 180.0 - B - C;
        return c * Math.sin(Math.toRadians(A)) / Math.sin(Math.toRadians(C));
    }

    @Deprecated
    public static double calculateDistanceToIonosphere2(double h, double hfAntennaTakeoffAngleInDegrees) {
        double a = Math.toRadians(hfAntennaTakeoffAngleInDegrees);
        double sinA2 = Math.pow(Math.sin(a), 2.0);
        double r2 = Math.pow(6371.0, 2.0);
        double h2 = Math.pow(h, 2.0);
        return -6371.0 * sinA2 + Math.sqrt(r2 * sinA2 + h2 + 12742.0 * h);
    }

    public static double calculateDistanceAcrossEarth(@NotNull PropagationApex apex) {
        double pi = Math.PI;
        double h = apex.getApexHeight();
        double theta = apex.getRadiationAngle();
        double d = apex.getDistanceToApex();
        double a = (6371.0 + h) / Math.toDegrees(Math.sin(Math.toRadians(90.0 + theta)));
        double A = Math.asin(Math.toRadians(d / a));
        return Math.toDegrees(A) / 360.0 * 2.0 * pi * 6371.0;
    }
}

