/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.coords;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gavaghan.geodesy.GlobalCoordinates;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LatLongUtils;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationFormatter;
import uk.m0nom.adifproc.coords.LocationParser;
import uk.m0nom.adifproc.coords.LocationSource;

public class DegreesDecimalMinutesWithNsewLatLongParser
implements LocationParser,
LocationFormatter {
    private static final Pattern PATTERN = Pattern.compile("(\\d+)[\\s|\u00b0]\\s*(\\d+\\.\\d+)[\\s|']\\s*([NnSs])\\s*(\\d+)[\\s|\u00b0]\\s*(\\d+\\.\\d+)[\\s|']*\\s*([EeWwOo])");

    @Override
    public Pattern getPattern() {
        return PATTERN;
    }

    @Override
    public GlobalCoords3D parse(LocationSource source, String location) {
        Matcher matcher = this.getPattern().matcher(location);
        if (matcher.find()) {
            String latDegrees = matcher.group(1);
            String latMinutes = matcher.group(2);
            String latNorthSouth = matcher.group(3).toUpperCase();
            String longDegrees = matcher.group(4);
            String longMinutes = matcher.group(5);
            String longEastWest = matcher.group(6).toUpperCase();
            Double latitude = LatLongUtils.parseDegDecimalMinLatitude(latDegrees, latMinutes, latNorthSouth);
            Double longitude = LatLongUtils.parseDegDecimalMinLongitude(longDegrees, longMinutes, longEastWest);
            if (latitude == null || longitude == null) {
                throw new UnsupportedOperationException();
            }
            return new GlobalCoords3D((double)latitude, (double)longitude, source, LocationAccuracy.LAT_LONG);
        }
        return null;
    }

    @Override
    public String format(GlobalCoordinates coords) {
        return String.format("%.0f\u00b0 %.3f' %s, %.0f\u00b0 %.3f' %s", Math.abs(LatLongUtils.getDegreesLat(coords)), Math.abs(LatLongUtils.getMinutesLat(coords)), LatLongUtils.getNorthSouth(coords), Math.abs(LatLongUtils.getDegreesLong(coords)), Math.abs(LatLongUtils.getMinutesLong(coords)), LatLongUtils.getEastWest(coords));
    }

    @Override
    public String getName() {
        return "Degrees Decimal Minutes Lat/Long with NSEW indicator";
    }
}

