/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.coords;

import java.util.ArrayList;
import java.util.List;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.coords.AdifLatLongParser;
import uk.m0nom.adifproc.coords.CommaSeparatedDecimalLatLongParser;
import uk.m0nom.adifproc.coords.CommaSeparatedDecimalLatLongWithAltitudeParser;
import uk.m0nom.adifproc.coords.CommaSeparatedDecimalWithNsewLatLongParser;
import uk.m0nom.adifproc.coords.CommaSeparatedDegreesDecimalMinutesWithNsewLatLongParser;
import uk.m0nom.adifproc.coords.DegreesDecimalLatLongParser;
import uk.m0nom.adifproc.coords.DegreesDecimalMinutesLatLongParser;
import uk.m0nom.adifproc.coords.DegreesDecimalMinutesWithNsewLatLongParser;
import uk.m0nom.adifproc.coords.DegreesDecimalWithNsewLatLongParser;
import uk.m0nom.adifproc.coords.DegreesMinutesDecimalSecondsWithNsewLatLongParser;
import uk.m0nom.adifproc.coords.DegreesMinutesSecondsLatLongParser;
import uk.m0nom.adifproc.coords.DegreesMinutesSecondsWithNsewLatLongParser;
import uk.m0nom.adifproc.coords.DegreesMinutesWithNsewLatLongParser;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.IrishGridParser5Digit;
import uk.m0nom.adifproc.coords.LocationFormatter;
import uk.m0nom.adifproc.coords.LocationParser;
import uk.m0nom.adifproc.coords.LocationParserResult;
import uk.m0nom.adifproc.coords.LocationSource;
import uk.m0nom.adifproc.coords.Maidenhead10CharLocatorParser;
import uk.m0nom.adifproc.coords.Maidenhead4CharLocatorParser;
import uk.m0nom.adifproc.coords.Maidenhead6CharLocatorParser;
import uk.m0nom.adifproc.coords.Maidenhead8CharLocatorParser;
import uk.m0nom.adifproc.coords.NsewWithDegreesDecimalLatLongParser;
import uk.m0nom.adifproc.coords.OsGb36Parser3Digit;
import uk.m0nom.adifproc.coords.OsGb36Parser4Digit;
import uk.m0nom.adifproc.coords.OsGb36Parser5Digit;
import uk.m0nom.adifproc.coords.OsGb36Parser6Digit;
import uk.m0nom.adifproc.coords.WabParser;

@Service
public class LocationParsingService {
    private final List<LocationParser> parsers = new ArrayList<LocationParser>();

    public static boolean isAccurateParser(LocationParser parser) {
        return parser.getClass() != Maidenhead4CharLocatorParser.class && parser.getClass() != Maidenhead6CharLocatorParser.class;
    }

    public LocationParsingService() {
        this.parsers.add(new DegreesDecimalLatLongParser());
        this.parsers.add(new CommaSeparatedDecimalLatLongParser());
        this.parsers.add(new DegreesDecimalWithNsewLatLongParser());
        this.parsers.add(new CommaSeparatedDecimalWithNsewLatLongParser());
        this.parsers.add(new CommaSeparatedDegreesDecimalMinutesWithNsewLatLongParser());
        this.parsers.add(new DegreesDecimalMinutesLatLongParser());
        this.parsers.add(new DegreesDecimalMinutesWithNsewLatLongParser());
        this.parsers.add(new CommaSeparatedDecimalLatLongWithAltitudeParser());
        this.parsers.add(new NsewWithDegreesDecimalLatLongParser());
        this.parsers.add(new DegreesMinutesSecondsLatLongParser());
        this.parsers.add(new DegreesMinutesSecondsWithNsewLatLongParser());
        this.parsers.add(new DegreesMinutesDecimalSecondsWithNsewLatLongParser());
        this.parsers.add(new DegreesMinutesWithNsewLatLongParser());
        this.parsers.add(new AdifLatLongParser("MY_"));
        this.parsers.add(new AdifLatLongParser(""));
        this.parsers.add(new Maidenhead10CharLocatorParser());
        this.parsers.add(new Maidenhead8CharLocatorParser());
        this.parsers.add(new Maidenhead6CharLocatorParser());
        this.parsers.add(new WabParser());
        this.parsers.add(new OsGb36Parser6Digit());
        this.parsers.add(new OsGb36Parser5Digit());
        this.parsers.add(new OsGb36Parser4Digit());
        this.parsers.add(new OsGb36Parser3Digit());
        this.parsers.add(new IrishGridParser5Digit());
    }

    public LocationParserResult parseStringForCoordinates(LocationSource source, String value) {
        String location = value.toUpperCase().trim();
        for (LocationParser parser : this.parsers) {
            GlobalCoords3D coords = parser.parse(source, location);
            if (coords == null) continue;
            return new LocationParserResult(coords, parser);
        }
        return null;
    }

    public List<String> format(GlobalCoordinates coords) {
        ArrayList<String> results = new ArrayList<String>(10);
        for (LocationParser parser : this.parsers) {
            if (!(parser instanceof LocationFormatter)) continue;
            results.add(((LocationFormatter)((Object)parser)).format(coords));
        }
        return results;
    }
}

