/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.dxcc;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class DxccPermutations {
    public static List<String> generate(String begin, String end) {
        if (begin.charAt(begin.length() - 1) != end.charAt(end.length() - 1)) {
            return DxccPermutations.generateInternal(begin, end);
        }
        int i = begin.length() - 1;
        while (begin.charAt(i) == end.charAt(i)) {
            --i;
        }
        int suffixStart = i + 1;
        String suffix = begin.substring(suffixStart);
        List<String> variants = DxccPermutations.generateInternal(begin.substring(0, suffixStart), end.substring(0, suffixStart));
        variants = variants.stream().map(variant -> variant.concat(suffix)).collect(Collectors.toList());
        return variants;
    }

    private static List<String> generateInternal(String begin, String end) {
        ArrayList<String> result = new ArrayList<String>();
        String current = begin;
        while (true) {
            result.add(current);
            if (current.equals(end)) break;
            current = DxccPermutations.getNextPermutation(current, end);
        }
        return result;
    }

    private static String getNextPermutation(String current, String end) {
        char[] candidate = current.toCharArray();
        DxccPermutations.createNextPermutation(candidate, current.length() - 1, end);
        return String.valueOf(candidate);
    }

    private static void createNextPermutation(char[] candidate, int index, String end) {
        char c = DxccPermutations.getNextChar(candidate[index]);
        if (c > end.charAt(index)) {
            candidate[index] = 97;
            DxccPermutations.createNextPermutation(candidate, index - 1, end);
        } else {
            candidate[index] = c;
        }
    }

    private static char getNextChar(char c) {
        return (char)(c + '\u0001');
    }
}

