/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.geodesic;

import java.util.List;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import uk.m0nom.adifproc.comms.PropagationApex;
import uk.m0nom.adifproc.coords.GlobalCoords3D;

public class GeodesicUtils {
    private static final double EARTH_RADIUS_IN_METRES = 6378000.0;

    public static double calculatePath(List<GlobalCoords3D> path, List<PropagationApex> bounces, GlobalCoords3D start, GlobalCoords3D end, double initialAzimuth) {
        GeodeticCalculator calculator = new GeodeticCalculator();
        path.add(new GlobalCoords3D(start.getLatitude(), start.getLongitude(), start.getAltitude()));
        GlobalCoords3D previous = start;
        double azimuth = initialAzimuth;
        double skyDistance = 0.0;
        for (int i = 0; i < bounces.size(); ++i) {
            PropagationApex bounce = bounces.get(i);
            double distanceAcrossGlobal = bounce.getDistanceAcrossEarth() * 1000.0;
            double reflectionHeight = bounce.getApexHeight();
            double baseHeight = bounce.getBaseHeight();
            double distanceOfHalfHop = distanceAcrossGlobal / 2.0;
            double halfCommsDistance = Math.sqrt(distanceOfHalfHop * distanceOfHalfHop + (reflectionHeight * reflectionHeight - baseHeight * baseHeight));
            skyDistance += halfCommsDistance * 2.0 / 1000.0;
            GlobalCoordinates apex = calculator.calculateEndingGlobalCoordinates(Ellipsoid.WGS84, (GlobalCoordinates)previous, azimuth, distanceAcrossGlobal / 2.0);
            path.add(new GlobalCoords3D(apex.getLatitude(), apex.getLongitude(), bounce.getApexHeight()));
            GeodeticCurve curve = calculator.calculateGeodeticCurve(Ellipsoid.WGS84, apex, (GlobalCoordinates)end);
            azimuth = curve.getAzimuth();
            if (i == bounces.size() - 1) {
                path.add(new GlobalCoords3D(end.getLatitude(), end.getLongitude(), end.getAltitude()));
                continue;
            }
            GlobalCoordinates rtn = calculator.calculateEndingGlobalCoordinates(Ellipsoid.WGS84, apex, azimuth, distanceAcrossGlobal / 2.0);
            path.add(new GlobalCoords3D(rtn.getLatitude(), rtn.getLongitude(), baseHeight));
            curve = calculator.calculateGeodeticCurve(Ellipsoid.WGS84, rtn, (GlobalCoordinates)end);
            azimuth = curve.getAzimuth();
            previous = rtn;
        }
        return skyDistance;
    }

    public static double geodesicDistanceToStraightLineDistance(double geodesicDistance) {
        double r = 6378000.0;
        return 2.0 * r * Math.sin(geodesicDistance / (2.0 * r));
    }

    public static boolean areCoordsEqual(GlobalCoordinates myCoords, GlobalCoordinates coords) {
        double tolerance = 1.0E-4;
        return Math.abs(myCoords.getLatitude() - coords.getLatitude()) < 1.0E-4 && Math.abs(myCoords.getLongitude() - coords.getLongitude()) < 1.0E-4;
    }

    public static Double getBearing(GlobalCoordinates myCoordinates, GlobalCoordinates coordinates) {
        Double bearing = null;
        if (myCoordinates != null && coordinates != null) {
            GeodeticCalculator calc = new GeodeticCalculator();
            GeodeticCurve curve = calc.calculateGeodeticCurve(Ellipsoid.WGS84, myCoordinates, coordinates);
            bearing = curve.getAzimuth();
        }
        return bearing;
    }
}

