/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.icons;

import org.marsik.ham.adif.enums.Mode;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.contacts.Station;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.icons.PortableIcons;

public class IconResource {
    public static final String FIXED_ICON_NAME = "fixed";
    public static final String PORTABLE_ICON_NAME = "portable";
    public static final String MOBILE_ICON_NAME = "mobile";
    public static final String MARITIME_MOBILE_ICON_NAME = "maritime";
    public static final String AERONAUTICAL_MOBILE_ICON_NAME = "aeroplane";
    public static final String CW_ICON_NAME = "cw";
    public static final String SSB_ICON_NAME = "ssb";
    public static final String FM_ICON_NAME = "fm";
    public static final String DEFAULT_MODE_ICON_NAME = "mode";
    public static final String SATELLITE_ICON_NAME = "satellite";
    public static final String SATELLITE_TRACK_ICON_NAME = "satellite_track";
    public static final String EMPTY_ICON_NAME = "empty";
    public static final String FIXED_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/ranger_station.png";
    public static final String PORTABLE_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/hiker.png";
    public static final String MOBILE_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/cabs.png";
    public static final String MARITIME_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/sailing.png";
    public static final String AERONAUTICAL_DEFAULT_ICON_URL = "http://maps.google.com/mapfiles/kml/shapes/airports.png";
    public static final String SATELLITE_DEFAULT_ICON_URL = "http://maps.google.com/mapfiles/kml/shapes/placemark_circle_highlight.png";
    public static final String SATELLITE_TRACK_DEFAULT_ICON_URL = "http://maps.google.com/mapfiles/kml/shapes/capital_big_highlight.png";
    public static final String POTA_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/picnic.png";
    public static final String SOTA_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/mountains.png";
    public static final String GMA_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/mountains.png";
    public static final String HEMA_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/hospitals.png";
    public static final String WOTA_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/trail.png";
    public static final String WWFF_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/parks.png";
    public static final String COTA_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/schools.png";
    public static final String LOTA_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/marina.png";
    public static final String ROTA_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/rail.png";
    public static final String IOTA_DEFAULT_ICON_URL = "https://maps.google.com/mapfiles/kml/shapes/info.png";
    public static final String BOTA_DEFAULT_ICON_URL = "http://maps.google.com/mapfiles/kml/shapes/caution.png";
    public static final String CW_DEFAULT_ICON_URL = "";
    private static final PortableIcons portableIcons = new PortableIcons();
    private final String name;
    private final String url;

    private IconResource(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public static IconResource getSatelliteTrackResource(TransformControl control) {
        return new IconResource(SATELLITE_TRACK_ICON_NAME, control.getIcon(SATELLITE_TRACK_ICON_NAME));
    }

    public static IconResource getSatelliteResource(TransformControl control) {
        return new IconResource(SATELLITE_ICON_NAME, control.getIcon(SATELLITE_ICON_NAME));
    }

    public static IconResource getMyIconFromStation(TransformControl control, Station station) {
        String cs = station.getCallsign();
        if (cs.endsWith("/P") && !"DEFAULT".equals(control.getPortableIcon())) {
            return new IconResource(control.getPortableIcon(), portableIcons.getIcon(control.getPortableIcon()).getIconUrl());
        }
        return IconResource.getIconFromStation(control, station);
    }

    public static IconResource getIconFromStation(TransformControl control, Station station) {
        String cs = station.getCallsign();
        IconResource icon = new IconResource(FIXED_ICON_NAME, control.getIcon(FIXED_ICON_NAME));
        for (ActivityType activity : ActivityType.values()) {
            if (!station.isDoing(activity)) continue;
            return new IconResource(activity.getActivityName(), control.getIcon(activity.getActivityName()));
        }
        if (cs.endsWith("/P")) {
            return new IconResource(PORTABLE_ICON_NAME, control.getIcon(PORTABLE_ICON_NAME));
        }
        if (cs.endsWith("/M")) {
            return new IconResource(MOBILE_ICON_NAME, control.getIcon(MOBILE_ICON_NAME));
        }
        if (cs.endsWith("/MM")) {
            return new IconResource(MARITIME_MOBILE_ICON_NAME, control.getIcon(MARITIME_MOBILE_ICON_NAME));
        }
        if (cs.endsWith("/AM")) {
            return new IconResource(AERONAUTICAL_MOBILE_ICON_NAME, control.getIcon(AERONAUTICAL_MOBILE_ICON_NAME));
        }
        return icon;
    }

    public static IconResource getIconFromMode(TransformControl control, Mode mode) {
        return switch (mode) {
            case Mode.CW -> new IconResource(CW_ICON_NAME, control.getIcon(CW_ICON_NAME));
            case Mode.SSB -> new IconResource(SSB_ICON_NAME, control.getIcon(SSB_ICON_NAME));
            case Mode.FM -> new IconResource(FM_ICON_NAME, control.getIcon(FM_ICON_NAME));
            default -> new IconResource(DEFAULT_MODE_ICON_NAME, control.getIcon(DEFAULT_MODE_ICON_NAME));
        };
    }

    public static IconResource getActivityIcon() {
        return new IconResource(EMPTY_ICON_NAME, CW_DEFAULT_ICON_URL);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }
}

