/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.icons;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import uk.m0nom.adifproc.icons.PortableIcon;

public class PortableIcons {
    private static final Logger logger = Logger.getLogger(PortableIcons.class.getName());
    private final List<PortableIcon> icons = new ArrayList<PortableIcon>(16);

    public PortableIcons() {
        this.addIcon("DEFAULT", "Default (Activity Specific)");
        this.addIcon("hiker", "On Foot");
        this.addIcon("bus", "Bus/Public Transport");
        this.addIcon("cabs", "Car/Van");
        this.addIcon("ferry", "Ferry");
        this.addIcon("heliport", "Helicopter");
        this.addIcon("campground", "Camping");
        this.addIcon("cycling", "Cycling");
        this.addIcon("motorcycling", "Motorcycle");
        this.addIcon("horsebackriding", "Horse Riding");
        this.addIcon("rail", "Rail");
        this.addIcon("sailing", "Sailing");
        this.addIcon("ski", "Skiing/Snowboarding");
        this.addIcon("swimming", "Swimming");
        this.addIcon("truck", "Truck");
        this.addIcon("tram", "Tram");
    }

    private void addIcon(String filename, String description) {
        PortableIcon icon = new PortableIcon(filename, description);
        this.icons.add(icon);
    }

    public List<PortableIcon> getIcons() {
        return this.icons;
    }

    public List<String> getIconNames() {
        return this.icons.stream().map(PortableIcon::getIconName).toList();
    }

    public PortableIcon getIcon(String iconName) {
        return this.icons.stream().filter(icon -> icon.getIconName().equals(iconName)).findFirst().orElse(null);
    }
}

