/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.irishgrid;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gavaghan.geodesy.GlobalCoordinates;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationSource;
import uk.m0nom.adifproc.irishgrid.IrishGridConverterResult;

public class IrishGridConverter {
    private double northings = 0.0;
    private double eastings = 0.0;
    private String status = "Undefined";
    private char[][] prefixes = new char[][]{{'V', 'Q', 'L', 'F', 'A'}, {'W', 'R', 'M', 'G', 'B'}, {'X', 'S', 'N', 'H', 'C'}, {'Y', 'T', 'O', 'J', 'D'}, {'Z', 'U', 'P', 'K', 'E'}};

    public void setError(String msg) {
        this.status = msg;
    }

    private String zeroPad(int num, int len) {
        StringBuilder str = new StringBuilder(Integer.toString(num));
        while (str.length() < len) {
            str.insert(0, '0');
        }
        return str.toString();
    }

    public String getGridRef(int precision) {
        char prefix;
        if (precision < 0) {
            precision = 0;
        }
        if (precision > 5) {
            precision = 5;
        }
        int x = 0;
        int y = 0;
        int e = 0;
        int n = 0;
        if (precision > 0) {
            y = (int)Math.floor(this.northings / 100000.0);
            x = (int)Math.floor(this.eastings / 100000.0);
            e = (int)Math.floor(this.eastings % 100000.0);
            n = (int)Math.floor(this.northings % 100000.0);
            int div = 5 - precision;
            e = (int)Math.floor((double)e / Math.pow(10.0, div));
            n = (int)Math.floor((double)n / Math.pow(10.0, div));
        }
        try {
            prefix = this.prefixes[x][y];
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return null;
        }
        return prefix + " " + this.zeroPad(e, precision) + " " + this.zeroPad(n, precision);
    }

    public IrishGridConverterResult convertIrishGridRefToWsg84(String irishGridRef) {
        IrishGridConverterResult result = new IrishGridConverterResult();
        result.setIrishGridRef(irishGridRef);
        if (this.parseGridRef(irishGridRef)) {
            result.setEasting(this.eastings);
            result.setNorthing(this.northings);
            GlobalCoordinates coords = this.getWGS84(true);
            result.setCoords(new GlobalCoords3D(coords, LocationSource.IRISH_GRID_REF_CONVERTER, LocationAccuracy.IRISH_GRID_REF_5DIGIT));
            result.setSuccess(true);
        }
        return result;
    }

    public IrishGridConverterResult convertCoordsToIrishGridRef(GlobalCoordinates coords) {
        IrishGridConverterResult result = new IrishGridConverterResult();
        result.setCoords(new GlobalCoords3D(coords, LocationSource.IRISH_GRID_REF_CONVERTER, LocationAccuracy.IRISH_GRID_REF_5DIGIT));
        String irishGridRef = this.getIrishGridRef(coords, true);
        if (irishGridRef != null) {
            result.setIrishGridRef(irishGridRef);
            result.setSuccess(true);
        }
        return result;
    }

    public boolean parseGridRef(String landranger) {
        this.northings = 0.0;
        this.eastings = 0.0;
        for (int precision = 5; precision >= 1; --precision) {
            Pattern pattern = Pattern.compile("^([A-Z]{1})\\s*(\\d{" + precision + "})\\s*(\\d{" + precision + "})$", 2);
            Matcher matcher = pattern.matcher(landranger);
            if (!matcher.matches()) continue;
            char gridSheet = matcher.group(1).charAt(0);
            double gridEast = 0.0;
            double gridNorth = 0.0;
            double mult = Math.pow(10.0, 5 - precision);
            gridEast = (double)Integer.valueOf(matcher.group(2), 10).intValue() * mult;
            gridNorth = (double)Integer.valueOf(matcher.group(3), 10).intValue() * mult;
            for (int x = 0; x < this.prefixes.length; ++x) {
                for (int y = 0; y < this.prefixes[x].length; ++y) {
                    if (this.prefixes[x][y] != gridSheet) continue;
                    this.eastings = (double)(x * 100000) + gridEast;
                    this.northings = (double)(y * 100000) + gridNorth;
                    return true;
                }
            }
        }
        return false;
    }

    public String getIrishGridRef(GlobalCoordinates coords, boolean uselevel2) {
        double longitude2;
        double latitude2;
        double height = 0.0;
        double latitude = coords.getLatitude();
        double longitude = coords.getLongitude();
        if (uselevel2) {
            double x1 = this.Lat_Long_H_to_X(latitude, longitude, height, 6378137.0, 6356752.313);
            double y1 = this.Lat_Long_H_to_Y(latitude, longitude, height, 6378137.0, 6356752.313);
            double z1 = this.Lat_H_to_Z(latitude, height, 6378137.0, 6356752.313);
            double x2 = this.Helmert_X(x1, y1, z1, -482.53, -0.214, -0.631, -8.15);
            double y2 = this.Helmert_Y(x1, y1, z1, 130.596, -1.042, -0.631, -8.15);
            double z2 = this.Helmert_Z(x1, y1, z1, -564.557, -1.042, -0.214, -8.15);
            latitude2 = this.XYZ_to_Lat(x2, y2, z2, 6377340.189, 6356034.447);
            longitude2 = this.XYZ_to_Long(x2, y2);
        } else {
            latitude2 = latitude;
            longitude2 = longitude;
        }
        double e = this.Lat_Long_to_East(latitude2, longitude2, 6377340.189, 6356034.447, 200000.0, 1.000035, 53.5, -8.0);
        double n = this.Lat_Long_to_North(latitude2, longitude2, 6377340.189, 6356034.447, 200000.0, 250000.0, 1.000035, 53.5, -8.0);
        if (!uselevel2) {
            e += 49.0;
            n -= 23.4;
        }
        this.eastings = Math.round(e);
        this.northings = Math.round(n);
        return this.getGridRef(5);
    }

    public GlobalCoordinates getWGS84(boolean uselevel2) {
        double n;
        double e;
        boolean height = false;
        if (uselevel2) {
            e = this.eastings;
            n = this.northings;
        } else {
            e = this.eastings - 49.0;
            n = this.northings + 23.4;
        }
        double lat1 = this.E_N_to_Lat(e, n, 6377340.189, 6356034.447, 200000.0, 250000.0, 1.000035, 53.5, -8.0);
        double lon1 = this.E_N_to_Long(e, n, 6377340.189, 6356034.447, 200000.0, 250000.0, 1.000035, 53.5, -8.0);
        if (uselevel2) {
            double x1 = this.Lat_Long_H_to_X(lat1, lon1, (double)height, 6377340.189, 6356034.447);
            double y1 = this.Lat_Long_H_to_Y(lat1, lon1, (double)height, 6377340.189, 6356034.447);
            double z1 = this.Lat_H_to_Z(lat1, (double)height, 6377340.189, 6356034.447);
            double x2 = this.Helmert_X(x1, y1, z1, 482.53, 0.214, 0.631, 8.15);
            double y2 = this.Helmert_Y(x1, y1, z1, -130.596, 1.042, 0.631, 8.15);
            double z2 = this.Helmert_Z(x1, y1, z1, 564.557, 1.042, 0.214, 8.15);
            double latitude = this.XYZ_to_Lat(x2, y2, z2, 6378137.0, 6356752.313);
            double longitude = this.XYZ_to_Long(x2, y2);
            return new GlobalCoords3D(latitude, longitude);
        }
        return new GlobalCoordinates(lat1, lon1);
    }

    private double E_N_to_Lat(double East, double North, double a, double b, double e0, double n0, double f0, double PHI0, double LAM0) {
        double RadPHI0 = PHI0 * (Math.PI / 180);
        double af0 = a * f0;
        double bf0 = b * f0;
        double e2 = (Math.pow(af0, 2.0) - Math.pow(bf0, 2.0)) / Math.pow(af0, 2.0);
        double n = (af0 - bf0) / (af0 + bf0);
        double Et = East - e0;
        double PHId = this.InitialLat(North, n0, af0, RadPHI0, n, bf0);
        double nu = af0 / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(PHId), 2.0));
        double rho = nu * (1.0 - e2) / (1.0 - e2 * Math.pow(Math.sin(PHId), 2.0));
        double eta2 = nu / rho - 1.0;
        double VII = Math.tan(PHId) / (2.0 * rho * nu);
        double VIII = Math.tan(PHId) / (24.0 * rho * Math.pow(nu, 3.0)) * (5.0 + 3.0 * Math.pow(Math.tan(PHId), 2.0) + eta2 - 9.0 * eta2 * Math.pow(Math.tan(PHId), 2.0));
        double IX = Math.tan(PHId) / (720.0 * rho * Math.pow(nu, 5.0)) * (61.0 + 90.0 * Math.pow(Math.tan(PHId), 2.0) + 45.0 * Math.pow(Math.tan(PHId), 4.0));
        return 57.29577951308232 * (PHId - Math.pow(Et, 2.0) * VII + Math.pow(Et, 4.0) * VIII - Math.pow(Et, 6.0) * IX);
    }

    private double E_N_to_Long(double East, double North, double a, double b, double e0, double n0, double f0, double PHI0, double LAM0) {
        double RadPHI0 = PHI0 * (Math.PI / 180);
        double RadLAM0 = LAM0 * (Math.PI / 180);
        double af0 = a * f0;
        double bf0 = b * f0;
        double e2 = (Math.pow(af0, 2.0) - Math.pow(bf0, 2.0)) / Math.pow(af0, 2.0);
        double n = (af0 - bf0) / (af0 + bf0);
        double Et = East - e0;
        double PHId = this.InitialLat(North, n0, af0, RadPHI0, n, bf0);
        double nu = af0 / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(PHId), 2.0));
        double rho = nu * (1.0 - e2) / (1.0 - e2 * Math.pow(Math.sin(PHId), 2.0));
        double X = Math.pow(Math.cos(PHId), -1.0) / nu;
        double XI = Math.pow(Math.cos(PHId), -1.0) / (6.0 * Math.pow(nu, 3.0)) * (nu / rho + 2.0 * Math.pow(Math.tan(PHId), 2.0));
        double XII = Math.pow(Math.cos(PHId), -1.0) / (120.0 * Math.pow(nu, 5.0)) * (5.0 + 28.0 * Math.pow(Math.tan(PHId), 2.0) + 24.0 * Math.pow(Math.tan(PHId), 4.0));
        double XIIA = Math.pow(Math.cos(PHId), -1.0) / (5040.0 * Math.pow(nu, 7.0)) * (61.0 + 662.0 * Math.pow(Math.tan(PHId), 2.0) + 1320.0 * Math.pow(Math.tan(PHId), 4.0) + 720.0 * Math.pow(Math.tan(PHId), 6.0));
        return 57.29577951308232 * (RadLAM0 + Et * X - Math.pow(Et, 3.0) * XI + Math.pow(Et, 5.0) * XII - Math.pow(Et, 7.0) * XIIA);
    }

    private double InitialLat(double North, double n0, double afo, double PHI0, double n, double bfo) {
        double PHI1 = (North - n0) / afo + PHI0;
        double M = this.Marc(bfo, n, PHI0, PHI1);
        double PHI2 = (North - n0 - M) / afo + PHI1;
        while (Math.abs(North - n0 - M) > 1.0E-5) {
            PHI2 = (North - n0 - M) / afo + PHI1;
            M = this.Marc(bfo, n, PHI0, PHI2);
            PHI1 = PHI2;
        }
        return PHI2;
    }

    private double Lat_Long_H_to_X(double PHI, double LAM, double H, double a, double b) {
        double RadPHI = PHI * (Math.PI / 180);
        double RadLAM = LAM * (Math.PI / 180);
        double e2 = (Math.pow(a, 2.0) - Math.pow(b, 2.0)) / Math.pow(a, 2.0);
        double V = a / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(RadPHI), 2.0));
        return (V + H) * Math.cos(RadPHI) * Math.cos(RadLAM);
    }

    private double Lat_Long_H_to_Y(double PHI, double LAM, double H, double a, double b) {
        double RadPHI = PHI * (Math.PI / 180);
        double RadLAM = LAM * (Math.PI / 180);
        double e2 = (Math.pow(a, 2.0) - Math.pow(b, 2.0)) / Math.pow(a, 2.0);
        double V = a / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(RadPHI), 2.0));
        return (V + H) * Math.cos(RadPHI) * Math.sin(RadLAM);
    }

    private double Lat_H_to_Z(double PHI, double H, double a, double b) {
        double RadPHI = PHI * (Math.PI / 180);
        double e2 = (Math.pow(a, 2.0) - Math.pow(b, 2.0)) / Math.pow(a, 2.0);
        double V = a / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(RadPHI), 2.0));
        return (V * (1.0 - e2) + H) * Math.sin(RadPHI);
    }

    public double Helmert_X(double X, double Y, double Z, double DX, double Y_Rot, double Z_Rot, double s) {
        double sfactor = s * 1.0E-6;
        double RadY_Rot = Y_Rot / 3600.0 * (Math.PI / 180);
        double RadZ_Rot = Z_Rot / 3600.0 * (Math.PI / 180);
        return X + X * sfactor - Y * RadZ_Rot + Z * RadY_Rot + DX;
    }

    private double Helmert_Y(double X, double Y, double Z, double DY, double X_Rot, double Z_Rot, double s) {
        double sfactor = s * 1.0E-6;
        double RadX_Rot = X_Rot / 3600.0 * (Math.PI / 180);
        double RadZ_Rot = Z_Rot / 3600.0 * (Math.PI / 180);
        return X * RadZ_Rot + Y + Y * sfactor - Z * RadX_Rot + DY;
    }

    public double Helmert_Z(double X, double Y, double Z, double DZ, double X_Rot, double Y_Rot, double s) {
        double sfactor = s * 1.0E-6;
        double RadX_Rot = X_Rot / 3600.0 * (Math.PI / 180);
        double RadY_Rot = Y_Rot / 3600.0 * (Math.PI / 180);
        return -1.0 * X * RadY_Rot + Y * RadX_Rot + Z + Z * sfactor + DZ;
    }

    private double XYZ_to_Lat(double X, double Y, double Z, double a, double b) {
        double RootXYSqr = Math.sqrt(Math.pow(X, 2.0) + Math.pow(Y, 2.0));
        double e2 = (Math.pow(a, 2.0) - Math.pow(b, 2.0)) / Math.pow(a, 2.0);
        double PHI1 = Math.atan2(Z, RootXYSqr * (1.0 - e2));
        double PHI = this.Iterate_XYZ_to_Lat(a, e2, PHI1, Z, RootXYSqr);
        return PHI * 57.29577951308232;
    }

    private double Iterate_XYZ_to_Lat(double a, double e2, double PHI1, double Z, double RootXYSqr) {
        double V = a / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(PHI1), 2.0));
        double PHI2 = Math.atan2(Z + e2 * V * Math.sin(PHI1), RootXYSqr);
        while (Math.abs(PHI1 - PHI2) > 1.0E-9) {
            PHI1 = PHI2;
            V = a / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(PHI1), 2.0));
            PHI2 = Math.atan2(Z + e2 * V * Math.sin(PHI1), RootXYSqr);
        }
        return PHI2;
    }

    private double XYZ_to_Long(double x, double y) {
        return Math.atan2(y, x) * 57.29577951308232;
    }

    private double Marc(double bf0, double n, double PHI0, double PHI) {
        return bf0 * ((1.0 + n + 1.25 * Math.pow(n, 2.0) + 1.25 * Math.pow(n, 3.0)) * (PHI - PHI0) - (3.0 * n + 3.0 * Math.pow(n, 2.0) + 2.625 * Math.pow(n, 3.0)) * Math.sin(PHI - PHI0) * Math.cos(PHI + PHI0) + (1.875 * Math.pow(n, 2.0) + 1.875 * Math.pow(n, 3.0)) * Math.sin(2.0 * (PHI - PHI0)) * Math.cos(2.0 * (PHI + PHI0)) - 1.4583333333333333 * Math.pow(n, 3.0) * Math.sin(3.0 * (PHI - PHI0)) * Math.cos(3.0 * (PHI + PHI0)));
    }

    public double Lat_Long_to_East(double PHI, double LAM, double a, double b, double e0, double f0, double PHI0, double LAM0) {
        double RadPHI = PHI * (Math.PI / 180);
        double RadLAM = LAM * (Math.PI / 180);
        double RadPHI0 = PHI0 * (Math.PI / 180);
        double RadLAM0 = LAM0 * (Math.PI / 180);
        double af0 = a * f0;
        double bf0 = b * f0;
        double e2 = (Math.pow(af0, 2.0) - Math.pow(bf0, 2.0)) / Math.pow(af0, 2.0);
        double n = (af0 - bf0) / (af0 + bf0);
        double nu = af0 / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(RadPHI), 2.0));
        double rho = nu * (1.0 - e2) / (1.0 - e2 * Math.pow(Math.sin(RadPHI), 2.0));
        double eta2 = nu / rho - 1.0;
        double p = RadLAM - RadLAM0;
        double IV = nu * Math.cos(RadPHI);
        double V = nu / 6.0 * Math.pow(Math.cos(RadPHI), 3.0) * (nu / rho - Math.pow(Math.tan(RadPHI), 2.0));
        double VI = nu / 120.0 * Math.pow(Math.cos(RadPHI), 5.0) * (5.0 - 18.0 * Math.pow(Math.tan(RadPHI), 2.0) + Math.pow(Math.tan(RadPHI), 4.0) + 14.0 * eta2 - 58.0 * Math.pow(Math.tan(RadPHI), 2.0) * eta2);
        return e0 + p * IV + Math.pow(p, 3.0) * V + Math.pow(p, 5.0) * VI;
    }

    public double Lat_Long_to_North(double PHI, double LAM, double a, double b, double e0, double n0, double f0, double PHI0, double LAM0) {
        double RadPHI = PHI * (Math.PI / 180);
        double RadLAM = LAM * (Math.PI / 180);
        double RadPHI0 = PHI0 * (Math.PI / 180);
        double RadLAM0 = LAM0 * (Math.PI / 180);
        double af0 = a * f0;
        double bf0 = b * f0;
        double e2 = (Math.pow(af0, 2.0) - Math.pow(bf0, 2.0)) / Math.pow(af0, 2.0);
        double n = (af0 - bf0) / (af0 + bf0);
        double nu = af0 / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(RadPHI), 2.0));
        double rho = nu * (1.0 - e2) / (1.0 - e2 * Math.pow(Math.sin(RadPHI), 2.0));
        double eta2 = nu / rho - 1.0;
        double p = RadLAM - RadLAM0;
        double M = this.Marc(bf0, n, RadPHI0, RadPHI);
        double I = M + n0;
        double II = nu / 2.0 * Math.sin(RadPHI) * Math.cos(RadPHI);
        double III = nu / 24.0 * Math.sin(RadPHI) * Math.pow(Math.cos(RadPHI), 3.0) * (5.0 - Math.pow(Math.tan(RadPHI), 2.0) + 9.0 * eta2);
        double IIIA = nu / 720.0 * Math.sin(RadPHI) * Math.pow(Math.cos(RadPHI), 5.0) * (61.0 - 58.0 * Math.pow(Math.tan(RadPHI), 2.0) + Math.pow(Math.tan(RadPHI), 4.0));
        return I + Math.pow(p, 2.0) * II + Math.pow(p, 4.0) * III + Math.pow(p, 6.0) * IIIA;
    }

    public double getNorthings() {
        return this.northings;
    }

    public double getEastings() {
        return this.eastings;
    }

    public String getStatus() {
        return this.status;
    }

    public char[][] getPrefixes() {
        return this.prefixes;
    }

    public void setNorthings(double northings) {
        this.northings = northings;
    }

    public void setEastings(double eastings) {
        this.eastings = eastings;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setPrefixes(char[][] prefixes) {
        this.prefixes = prefixes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IrishGridConverter)) {
            return false;
        }
        IrishGridConverter other = (IrishGridConverter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getNorthings(), other.getNorthings()) != 0) {
            return false;
        }
        if (Double.compare(this.getEastings(), other.getEastings()) != 0) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getPrefixes(), (Object[])other.getPrefixes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof IrishGridConverter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $northings = Double.doubleToLongBits(this.getNorthings());
        result = result * 59 + (int)($northings >>> 32 ^ $northings);
        long $eastings = Double.doubleToLongBits(this.getEastings());
        result = result * 59 + (int)($eastings >>> 32 ^ $eastings);
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getPrefixes());
        return result;
    }

    public String toString() {
        return "IrishGridConverter(northings=" + this.getNorthings() + ", eastings=" + this.getEastings() + ", status=" + this.getStatus() + ", prefixes=" + Arrays.deepToString((Object[])this.getPrefixes()) + ")";
    }
}

