/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.kml.info;

import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.Adif3Record;
import org.thymeleaf.context.Context;
import uk.m0nom.adifproc.comms.CommsLinkResult;
import uk.m0nom.adifproc.util.FrequencyFormatter;

public class KmlBaseInfoPanel {
    protected static final double ONE_HZ = 1.0E-6;
    protected static final double MILES_PER_KM = 0.621371;

    protected void setBaseInfo(Adif3Record rec, Context context, CommsLinkResult commsLink) {
        if (rec.getMode() != null) {
            context.setVariable("mode", (Object)rec.getMode().toString());
        }
        if (rec.getFreq() != null) {
            context.setVariable("freq", (Object)FrequencyFormatter.formatFrequency(rec.getFreq()));
            if (rec.getFreqRx() != null && Math.abs(rec.getFreq() - rec.getFreqRx()) >= 1.0E-6) {
                context.setVariable("downlinkFreq", (Object)FrequencyFormatter.formatFrequency(rec.getFreqRx()));
            }
        }
        if (rec.getTxPwr() != null) {
            context.setVariable("txPwr", (Object)String.format("%,.1f", rec.getTxPwr()));
            if (commsLink != null) {
                context.setVariable("txPwrDistKmRatio", (Object)this.calculateWattsPerKmForDisplay(rec.getTxPwr(), commsLink.getDistanceInKm()));
                context.setVariable("txPwrDistMileRatio", (Object)this.calculateWattsPerMileForDisplay(rec.getTxPwr(), commsLink.getDistanceInKm()));
            }
        }
        if (rec.getRxPwr() != null) {
            context.setVariable("rxPwr", (Object)String.format("%,.1f", rec.getRxPwr()));
            if (commsLink != null) {
                context.setVariable("rxPwrDistKmRatio", (Object)this.calculateWattsPerKmForDisplay(rec.getRxPwr(), commsLink.getDistanceInKm()));
                context.setVariable("rxPwrDistMileRatio", (Object)this.calculateWattsPerMileForDisplay(rec.getRxPwr(), commsLink.getDistanceInKm()));
            }
        }
        if (rec.getBand() != null) {
            if (rec.getBandRx() != null) {
                context.setVariable("uplinkBand", (Object)StringUtils.replace((String)rec.getBand().name(), (String)"BAND_", (String)"").toLowerCase());
                context.setVariable("downlinkBand", (Object)StringUtils.replace((String)rec.getBandRx().name(), (String)"BAND_", (String)"").toLowerCase());
            } else {
                context.setVariable("band", (Object)StringUtils.replace((String)rec.getBand().name(), (String)"BAND_", (String)"").toLowerCase());
            }
        }
        if (commsLink != null) {
            context.setVariable("gndDist", (Object)String.format("%,.0f", commsLink.getDistanceInKm()));
            context.setVariable("gndDistMiles", (Object)String.format("%,.0f", commsLink.getDistanceInKm() * 0.621371));
        }
    }

    private String calculateWattsPerKmForDisplay(Double txPwr, double distanceInKm) {
        if (txPwr == null) {
            return null;
        }
        double wattsPerKm = txPwr / distanceInKm;
        if (wattsPerKm < 0.001) {
            return String.format("%,.0f uw/km", wattsPerKm * 1000000.0);
        }
        if (wattsPerKm < 1.0) {
            return String.format("%,.0f mw/km", wattsPerKm * 1000.0);
        }
        return String.format("%,.1f w/km", wattsPerKm);
    }

    private String calculateWattsPerMileForDisplay(Double txPwr, double distanceInKm) {
        if (txPwr == null) {
            return null;
        }
        double wattsPerMile = txPwr / distanceInKm / 0.621371;
        if (wattsPerMile < 0.001) {
            return String.format("%,.0f uw/mile", wattsPerMile * 1000000.0);
        }
        if (wattsPerMile < 0.1) {
            return String.format("%,.0f mw/mile", wattsPerMile * 1000.0);
        }
        return String.format("%,.1f w/mile", wattsPerMile);
    }
}

