/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.kml.info;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.contacts.Station;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.comms.CommsLinkResult;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationInfo;
import uk.m0nom.adifproc.dxcc.Country;
import uk.m0nom.adifproc.dxcc.DxccEntity;
import uk.m0nom.adifproc.kml.info.KmlBaseInfoPanel;
import uk.m0nom.adifproc.qrz.QrzCallsign;

public class KmlStationInfoPanel
extends KmlBaseInfoPanel {
    public String getPanelContentForStation(TransformControl control, Station station, CommsLinkResult result) {
        String grid;
        Context context = new Context();
        this.setBaseInfo(station.getQsos().get(0).getRecord(), context, result);
        String callSign = station.getCallsign();
        context.setVariable("call", (Object)callSign);
        QrzCallsign qrzInfo = station.getQrzInfo();
        if (qrzInfo != null) {
            this.setVariable(context, "callForQrz", station.getQrzInfo().getCall());
            if (qrzInfo.getImage() != null) {
                context.setVariable("image", (Object)station.getQrzInfo().getImage());
            }
        } else {
            context.setVariable("callForQrz", (Object)callSign);
        }
        for (ActivityType activityType : ActivityType.values()) {
            if (!station.isDoing(activityType)) continue;
            Collection<Activity> activitiesOfType = station.getActivity(activityType);
            context.setVariable(activityType.getActivityName().toLowerCase() + "s", activitiesOfType);
        }
        if (qrzInfo != null) {
            this.setVariable(context, "name", String.format("%s %s", StringUtils.defaultIfBlank((CharSequence)qrzInfo.getFname(), (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)qrzInfo.getName(), (CharSequence)"")));
        }
        if (station.getDxccEntity() != null) {
            DxccEntity dxcc = station.getDxccEntity();
            Country country = control.getCountries().getCountry(dxcc.getCountryCode());
            String name = dxcc.getName();
            if (country != null) {
                name = country.getName();
            }
            this.setVariable(context, "country", name);
            if ("United states".equalsIgnoreCase(name) && qrzInfo != null && qrzInfo.getCountry() != null && name.equalsIgnoreCase(qrzInfo.getCountry())) {
                this.setVariable(context, "state", qrzInfo.getState());
            }
            this.setVariable(context, "dxcc", dxcc.getName());
            this.setVariable(context, "flag", dxcc.getFlag());
            this.setVariable(context, "ituZone", this.formatIntList(dxcc.getItu()));
            this.setVariable(context, "cqZone", this.formatIntList(dxcc.getCq()));
        }
        if (station.getCoordinates() != null && station.getCoordinates().getAltitude() > 0.0) {
            this.setVariable(context, "altitude", String.format("%.0f m", station.getCoordinates().getAltitude()));
        }
        if ((grid = station.getGrid()) == null && qrzInfo != null) {
            grid = qrzInfo.getGrid();
        }
        this.setVariable(context, "grid", grid);
        GlobalCoords3D coordinates = station.getCoordinates();
        if (coordinates == null && qrzInfo != null) {
            coordinates = new GlobalCoords3D(qrzInfo.getLat(), (double)qrzInfo.getLon());
        }
        if (coordinates != null) {
            context.setVariable("lat", (Object)String.format("%.3f", coordinates.getLatitude()));
            context.setVariable("long", (Object)String.format("%.3f", coordinates.getLongitude()));
            LocationInfo info = coordinates.getLocationInfo();
            context.setVariable("locationSource", (Object)info.getSource().getDescription());
            context.setVariable("locationAccuracy", (Object)info.getAccuracy().getDescription());
        }
        String template = "KmlStationInfo";
        if (control.isCompactQsoTemplate()) {
            template = "KmlCompactStationInfo";
        }
        String html = control.getTemplateEngine().process(new TemplateSpec(template, TemplateMode.XML), (IContext)context);
        return html.replace("\n", "");
    }

    private String formatIntList(Collection<Integer> intList) {
        return intList.stream().map(String::valueOf).collect(Collectors.joining(", "));
    }

    private void setVariable(Context context, String key, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            context.setVariable(key, (Object)value);
        }
    }
}

