/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.maidenheadlocator;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gavaghan.geodesy.GlobalCoordinates;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationParserResult;
import uk.m0nom.adifproc.coords.LocationSource;

public class MaidenheadLocatorConversion {
    public static final Pattern LOC_4CHAR = Pattern.compile("^[A-R]{2}[0-9]{2}$");
    public static final Pattern LOC_6CHAR = Pattern.compile("^[A-R]{2}[0-9]{2}[A-X]{2}$");
    public static final Pattern LOC_8CHAR = Pattern.compile("^|[A-R]{2}[0-9]{2}[A-X]{2}[0-9]{2}$");
    public static final Pattern LOC_10CHAR = Pattern.compile("^[A-R]{2}[0-9]{2}[A-X]{2}[0-9]{2}[A-X]{2}$");
    public static final Pattern LOC_12CHAR = Pattern.compile("^[A-R]{2}[0-9]{2}[A-X]{2}[0-9]{2}[A-X]{2}[0-9]{2}$");
    private static final Collection<String> DUBIOUS_GRID_SQUARES = Arrays.asList("IO91VL", "JJ00AA", "AA00AA", "JJ00AA00", "AA00AA00");

    public static boolean isADubiousGridSquare(String grid) {
        return grid != null && DUBIOUS_GRID_SQUARES.contains(grid.toUpperCase());
    }

    public static boolean isEmptyOrInvalid(String gridSquare) {
        return gridSquare == null || MaidenheadLocatorConversion.isADubiousGridSquare(gridSquare);
    }

    public static boolean isValid(String gridSquare) {
        return gridSquare != null && MaidenheadLocatorConversion.isAWellFormedGridsquare(gridSquare) && !MaidenheadLocatorConversion.isADubiousGridSquare(gridSquare);
    }

    public static GlobalCoords3D locatorToCoords(LocationSource source, String locStr) {
        return MaidenheadLocatorConversion.locatorToCoords(source, locStr, null);
    }

    public static GlobalCoords3D locatorToCoords(LocationSource source, String locStr, String extStr) {
        Object locatorTrimmed = locStr.trim().toUpperCase();
        if (extStr != null) {
            locatorTrimmed = (String)locatorTrimmed + extStr.trim().toUpperCase();
        }
        Matcher matcher4Char = LOC_4CHAR.matcher((CharSequence)locatorTrimmed);
        Matcher matcher6Char = LOC_6CHAR.matcher((CharSequence)locatorTrimmed);
        Matcher matcher8Char = LOC_8CHAR.matcher((CharSequence)locatorTrimmed);
        Matcher matcher10Char = LOC_10CHAR.matcher((CharSequence)locatorTrimmed);
        Matcher matcher12Char = LOC_12CHAR.matcher((CharSequence)locatorTrimmed);
        char[] locator = ((String)locatorTrimmed).toCharArray();
        try {
            if (matcher12Char.matches()) {
                double longitude = (double)((locator[0] - 65) * 20 + (locator[2] - 48) * 2) + ((double)(locator[4] - 65) + 0.0) / 12.0 + ((double)(locator[6] - 48) + 0.0) / 120.0 + ((double)(locator[8] - 65) + 0.5) / 120.0 / 24.0 - 180.0;
                double latitude = (double)((locator[1] - 65) * 10 + (locator[3] - 48)) + ((double)(locator[5] - 65) + 0.0) / 24.0 + ((double)(locator[7] - 48) + 0.0) / 240.0 + ((double)(locator[9] - 65) + 0.5) / 240.0 / 24.0 - 90.0;
                return new GlobalCoords3D(latitude, longitude, source, LocationAccuracy.MHL12);
            }
            if (matcher10Char.matches()) {
                double longitude = (double)((locator[0] - 65) * 20 + (locator[2] - 48) * 2) + ((double)(locator[4] - 65) + 0.0) / 12.0 + ((double)(locator[6] - 48) + 0.0) / 120.0 + ((double)(locator[8] - 65) + 0.5) / 120.0 / 24.0 - 180.0;
                double latitude = (double)((locator[1] - 65) * 10 + (locator[3] - 48)) + ((double)(locator[5] - 65) + 0.0) / 24.0 + ((double)(locator[7] - 48) + 0.0) / 240.0 + ((double)(locator[9] - 65) + 0.5) / 240.0 / 24.0 - 90.0;
                return new GlobalCoords3D(latitude, longitude, source, LocationAccuracy.MHL10);
            }
            if (matcher8Char.matches()) {
                double longitude = (double)((locator[0] - 65) * 20 + (locator[2] - 48) * 2) + ((double)(locator[4] - 65) + 0.0) / 12.0 + ((double)(locator[6] - 48) + 0.5) / 120.0 - 180.0;
                double latitude = (double)((locator[1] - 65) * 10 + (locator[3] - 48)) + ((double)(locator[5] - 65) + 0.0) / 24.0 + ((double)(locator[7] - 48) + 0.5) / 240.0 - 90.0;
                return new GlobalCoords3D(latitude, longitude, source, LocationAccuracy.MHL8);
            }
            if (matcher6Char.matches()) {
                double longitude = (double)((locator[0] - 65) * 20 + (locator[2] - 48) * 2) + ((double)(locator[4] - 65) + 0.5) / 12.0 - 180.0;
                double latitude = (double)((locator[1] - 65) * 10 + (locator[3] - 48)) + ((double)(locator[5] - 65) + 0.5) / 24.0 - 90.0;
                return new GlobalCoords3D(latitude, longitude, source, LocationAccuracy.MHL6);
            }
            if (matcher4Char.matches()) {
                double latitude = (double)((locator[1] - 65) * 10) + ((double)(locator[3] - 48) + 0.5) - 90.0;
                double longitude = (double)((locator[0] - 65) * 20) + ((double)(locator[2] - 48) + 0.5) * 2.0 - 180.0;
                return new GlobalCoords3D(latitude, longitude, source, LocationAccuracy.MHL4);
            }
            throw new UnsupportedOperationException(String.format("Invalid locator format: %s", locatorTrimmed));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("Invalid locator format: %s", locatorTrimmed));
        }
    }

    public static String coordsToLocator(GlobalCoordinates coords) {
        return MaidenheadLocatorConversion.coordsToLocator(coords, 6);
    }

    public static String locationParserResultToLocator(LocationParserResult result) {
        LocationAccuracy accuracy = result.getCoords().getLocationInfo().getAccuracy();
        switch (accuracy) {
            case MHL8: {
                return MaidenheadLocatorConversion.coordsToLocator(result.getCoords(), 8);
            }
            case MHL10: {
                return MaidenheadLocatorConversion.coordsToLocator(result.getCoords(), 10);
            }
            case MHL12: {
                return MaidenheadLocatorConversion.coordsToLocator(result.getCoords(), 12);
            }
        }
        return MaidenheadLocatorConversion.coordsToLocator(result.getCoords());
    }

    public static String coordsToLocator(GlobalCoordinates coords, int len) {
        Object locator = "";
        double latitude = coords.getLatitude() + 90.0;
        double longitude = coords.getLongitude() + 180.0;
        locator = (String)locator + (char)(65.0 + Math.floor(longitude / 20.0));
        locator = (String)locator + (char)(65.0 + Math.floor(latitude / 10.0));
        if ((longitude = Math.IEEEremainder(longitude, 20.0)) < 0.0) {
            longitude += 20.0;
        }
        if ((latitude = Math.IEEEremainder(latitude, 10.0)) < 0.0) {
            latitude += 10.0;
        }
        locator = (String)locator + (char)(48.0 + Math.floor(longitude / 2.0));
        locator = (String)locator + (char)(48.0 + Math.floor(latitude));
        if ((longitude = Math.IEEEremainder(longitude, 2.0)) < 0.0) {
            longitude += 2.0;
        }
        if ((latitude = Math.IEEEremainder(latitude, 1.0)) < 0.0) {
            latitude += 1.0;
        }
        if (len > 4) {
            locator = (String)locator + (char)(65.0 + Math.floor(longitude * 12.0));
            locator = (String)locator + (char)(65.0 + Math.floor(latitude * 24.0));
            if ((longitude = Math.IEEEremainder(longitude, 0.08333333333333333)) < 0.0) {
                longitude += 0.08333333333333333;
            }
            if ((latitude = Math.IEEEremainder(latitude, 0.041666666666666664)) < 0.0) {
                latitude += 0.041666666666666664;
            }
            if (len > 6) {
                locator = (String)locator + (char)(48.0 + Math.floor(longitude * 120.0));
                locator = (String)locator + (char)(48.0 + Math.floor(latitude * 240.0));
                if ((longitude = Math.IEEEremainder(longitude, 0.008333333333333333)) < 0.0) {
                    longitude += 0.008333333333333333;
                }
                if ((latitude = Math.IEEEremainder(latitude, 0.004166666666666667)) < 0.0) {
                    latitude += 0.004166666666666667;
                }
                if (len > 8) {
                    locator = (String)locator + (char)(65.0 + Math.floor(longitude * 120.0 * 24.0));
                    locator = (String)locator + (char)(65.0 + Math.floor(latitude * 240.0 * 24.0));
                }
            }
        }
        return locator;
    }

    public static double distance(String a, String b) {
        return MaidenheadLocatorConversion.distance(MaidenheadLocatorConversion.locatorToCoords(LocationSource.UNDEFINED, a), MaidenheadLocatorConversion.locatorToCoords(LocationSource.UNDEFINED, b));
    }

    public static double distance(GlobalCoordinates a, GlobalCoordinates b) {
        if (a.compareTo(b) == 0) {
            return 0.0;
        }
        double hn = Math.toRadians(a.getLatitude());
        double he = Math.toRadians(a.getLongitude());
        double n = Math.toRadians(b.getLatitude());
        double e = Math.toRadians(b.getLongitude());
        double co = Math.cos(he - e) * Math.cos(hn) * Math.cos(n) + Math.sin(hn) * Math.sin(n);
        double ca = Math.atan(Math.abs(Math.sqrt(1.0 - co * co) / co));
        if (co < 0.0) {
            ca = Math.PI - ca;
        }
        return 6367.0 * ca;
    }

    public static double azimuth(String a, String b) {
        return MaidenheadLocatorConversion.azimuth(MaidenheadLocatorConversion.locatorToCoords(LocationSource.UNDEFINED, a), MaidenheadLocatorConversion.locatorToCoords(LocationSource.UNDEFINED, b));
    }

    public static double azimuth(GlobalCoordinates a, GlobalCoordinates b) {
        if (a.compareTo(b) == 0) {
            return 0.0;
        }
        double hn = Math.toRadians(a.getLatitude());
        double he = Math.toRadians(a.getLongitude());
        double n = Math.toRadians(b.getLatitude());
        double e = Math.toRadians(b.getLongitude());
        double co = Math.cos(he - e) * Math.cos(hn) * Math.cos(n) + Math.sin(hn) * Math.sin(n);
        double ca = Math.atan(Math.abs(Math.sqrt(1.0 - co * co) / co));
        if (co < 0.0) {
            ca = Math.PI - ca;
        }
        double si = Math.sin(e - he) * Math.cos(n) * Math.cos(hn);
        co = Math.sin(n) - Math.sin(hn) * Math.cos(ca);
        double az = Math.atan(Math.abs(si / co));
        if (co < 0.0) {
            az = Math.PI - az;
        }
        if (si < 0.0) {
            az = -az;
        }
        if (az < 0.0) {
            az += Math.PI * 2;
        }
        return Math.toDegrees(az);
    }

    public static boolean isAWellFormedGridsquare(String locStr) {
        String locatorTrimmed = locStr.trim().toUpperCase();
        Matcher matcher4Char = LOC_4CHAR.matcher(locatorTrimmed);
        Matcher matcher6Char = LOC_6CHAR.matcher(locatorTrimmed);
        Matcher matcher8Char = LOC_8CHAR.matcher(locatorTrimmed);
        Matcher matcher10Char = LOC_10CHAR.matcher(locatorTrimmed);
        return matcher4Char.matches() || matcher6Char.matches() || matcher8Char.matches() || matcher10Char.matches();
    }
}

