/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.AdifHeader;
import org.marsik.ham.adif.enums.AdifEnumCode;
import org.marsik.ham.adif.types.AdifType;
import org.marsik.ham.grid.CoordinateWriter;

public class AdiWriter {
    static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HHmmss");
    static final DateTimeFormatter timeFormatterShort = DateTimeFormatter.ofPattern("HHmm");
    private final StringBuilder builder = new StringBuilder();

    public void append(String value) {
        this.builder.append(value);
    }

    public void append(String name, Boolean value) {
        if (value == null) {
            return;
        }
        this.appendFieldHeader(name, 1);
        this.builder.append(value != false ? "Y" : "N");
    }

    public void append(String name, String value) {
        if (value == null) {
            return;
        }
        String trimmed = this.encode(value);
        this.appendFieldHeader(name, trimmed.length());
        this.builder.append(trimmed);
    }

    public void append(String name, Integer value) {
        if (value == null) {
            return;
        }
        String trimmed = this.encode(value);
        this.appendFieldHeader(name, trimmed.length());
        this.builder.append(trimmed);
    }

    public void append(String name, Double value) {
        if (value == null) {
            return;
        }
        String trimmed = this.encode(value);
        this.appendFieldHeader(name, trimmed.length());
        this.builder.append(trimmed);
    }

    public void append(String name, AdifEnumCode value) {
        if (value == null) {
            return;
        }
        String code = this.encode(value);
        this.appendFieldHeader(name, code.length());
        this.builder.append(code);
    }

    public void append(String name, AdifType typeValue) {
        if (typeValue == null) {
            return;
        }
        String value = typeValue.getValue();
        this.appendFieldHeader(name, value.length());
        this.builder.append(value);
    }

    public void append(String name, LocalTime value) {
        if (value == null) {
            return;
        }
        String trimmed = this.encode(value);
        this.appendFieldHeader(name, trimmed.length());
        this.builder.append(trimmed);
    }

    public void append(String name, LocalDate value) {
        if (value == null) {
            return;
        }
        String trimmed = this.encode(value);
        this.appendFieldHeader(name, trimmed.length());
        this.builder.append(trimmed);
    }

    public void append(String name, ZonedDateTime value) {
        if (value == null) {
            return;
        }
        String trimmed = this.encode(value);
        this.appendFieldHeader(name, trimmed.length());
        this.builder.append(trimmed);
    }

    private String encode(String value) {
        return value.trim();
    }

    private String encode(Integer value) {
        return value.toString();
    }

    private String encode(Double value) {
        return String.format("%f", value);
    }

    private String encode(AdifEnumCode value) {
        return value.adifCode().toUpperCase();
    }

    private String encode(LocalDate value) {
        return value.format(dateFormatter);
    }

    private String encode(LocalTime value) {
        return value.format(timeFormatter);
    }

    private String encode(ZonedDateTime value) {
        return value.withZoneSameInstant(ZoneId.of("UTC")).format(dateFormatter);
    }

    private void appendFieldHeader(String name, Integer length) {
        this.builder.append("<");
        this.builder.append(name.toUpperCase());
        this.builder.append(":");
        this.builder.append(length);
        this.builder.append(">");
    }

    public void appendEndOfRecord() {
        this.builder.append("<EOR>\n");
    }

    public void appendEndOfHeader() {
        this.builder.append("<EOH>\n");
    }

    private void appendFieldHeader(String name, Integer length, String type) {
        this.builder.append("<");
        this.builder.append(name.toUpperCase());
        this.builder.append(":");
        this.builder.append(length);
        this.builder.append(":");
        this.builder.append(type.toUpperCase());
        this.builder.append(">");
    }

    public void appendIntegers(String name, Collection<Integer> values) {
        if (values == null) {
            return;
        }
        String value = values.stream().map(this::encode).collect(Collectors.joining(","));
        this.appendFieldHeader(name, value.length());
        this.builder.append(value);
    }

    public void appendStrings(String name, Collection<String> values) {
        if (values == null) {
            return;
        }
        String value = values.stream().map(this::encode).collect(Collectors.joining(","));
        this.appendFieldHeader(name, value.length());
        this.builder.append(value);
    }

    public void appendEnums(String name, Collection<AdifEnumCode> values) {
        if (values == null) {
            return;
        }
        String value = values.stream().map(this::encode).collect(Collectors.joining(","));
        this.appendFieldHeader(name, value.length());
        this.builder.append(value);
    }

    public void appendDoubles(String name, Collection<AdifEnumCode> values) {
        if (values == null) {
            return;
        }
        String value = values.stream().map(this::encode).collect(Collectors.joining(","));
        this.appendFieldHeader(name, value.length());
        this.builder.append(value);
    }

    public void appendCustomFields(Map<String, String> customFields) {
        for (String name : customFields.keySet()) {
            this.append(name, customFields.get(name));
        }
    }

    public String toString() {
        return this.builder.toString();
    }

    public void append(Adif3Record rec) {
        this.append("ADDRESS", rec.getAddress());
        this.append("AGE", rec.getAge());
        this.append("A_INDEX", rec.getAIndex());
        this.append("ANT_AZ", rec.getAntAz());
        this.append("ANT_EL", rec.getAntEl());
        this.append("ANT_PATH", rec.getAntPath());
        this.append("ARRL_SECT", rec.getArrlSect());
        this.appendStrings("AWARD_SUBMITTED", rec.getAwardSubmitted());
        this.appendStrings("AWARD_GRANTED", rec.getAwardGranted());
        this.append("BAND", rec.getBand());
        this.append("BAND_RX", rec.getBandRx());
        this.append("CALL", rec.getCall());
        this.append("CHECK", rec.getCheck());
        this.append("CLASS", rec.getContestClass());
        this.append("CLUBLOG_QSO_UPLOAD_DATE", rec.getClublogQsoUploadDate());
        this.append("CLUBLOG_QSO_UPLOAD_STATUS", rec.getClublogQsoUploadStatus());
        this.append("CNTY", rec.getCnty());
        this.append("COMMENT", rec.getComment());
        this.append("CONT", rec.getCont());
        this.append("CONTACTED_OP", rec.getContactedOp());
        this.append("CONTEST_ID", rec.getContestId());
        this.append("COUNTRY", rec.getCountry());
        this.append("CQZ", rec.getCqz());
        this.appendStrings("CREDIT_SUBMITTED", rec.getCreditSubmitted());
        this.appendStrings("CREDIT_GRANTED", rec.getCreditGranted());
        this.append("DARC_DOK", rec.getDarcDok());
        this.append("DISTANCE", rec.getDistance());
        this.append("DXCC", rec.getDxcc());
        this.append("EMAIL", rec.getEmail());
        this.append("EQ_CALL", rec.getEqCall());
        this.append("EQSL_QSLRDATE", rec.getEqslQslRDate());
        this.append("EQSL_QSLSDATE", rec.getEqslQslSDate());
        this.append("EQSL_QSL_RCVD", rec.getEqslQslRcvd());
        this.append("EQSL_QSL_SENT", rec.getEqslQslSent());
        this.append("FISTS", rec.getFists());
        this.append("FISTS_CC", rec.getFistsCc());
        this.append("FORCE_INT", rec.getForceInt());
        this.append("FREQ", rec.getFreq());
        this.append("FREQ_RX", rec.getFreqRx());
        this.append("GRIDSQUARE", rec.getGridsquare());
        this.append("HRDLOG_QSO_UPLOAD_DATE", rec.getHrdlogQsoUploadDate());
        this.append("HRDLOG_QSO_UPLOAD_STATUS", rec.getHrdlogQsoUploadStatus());
        this.append("IOTA", rec.getIota());
        this.append("IOTA_ISLAND_ID", rec.getIotaIslandId());
        this.append("ITUZ", rec.getItuz());
        this.append("K_INDEX", rec.getKIndex());
        if (rec.getCoordinates() != null) {
            this.append("LAT", CoordinateWriter.latToDM(rec.getCoordinates().getLatitude()));
            this.append("LON", CoordinateWriter.lonToDM(rec.getCoordinates().getLongitude()));
        }
        this.append("LOTW_QSLRDATE", rec.getLotwQslRDate());
        this.append("LOTW_QSLSDATE", rec.getLotwQslSDate());
        this.append("LOTW_QSL_RCVD", rec.getLotwQslRcvd());
        this.append("LOTW_QSL_SENT", rec.getLotwQslSent());
        this.append("MAX_BURSTS", rec.getMaxBursts());
        this.append("MODE", rec.getMode());
        this.append("MS_SHOWER", rec.getMsShower());
        this.append("MY_ANTENNA", rec.getMyAntenna());
        this.append("MY_CITY", rec.getMyCity());
        this.append("MY_CNTY", rec.getMyCnty());
        this.append("MY_COUNTRY", rec.getMyCountry());
        this.append("MY_CQ_ZONE", rec.getMyCqZone());
        this.append("MY_DXCC", rec.getMyDxcc());
        this.append("MY_FISTS", rec.getMyFists());
        this.append("MY_GRIDSQUARE", rec.getMyGridSquare());
        this.append("MY_IOTA", rec.getMyIota());
        this.append("MY_IOTA_ISLAND_ID", rec.getMyIotaIslandId());
        this.append("MY_ITU_ZONE", rec.getMyItuZone());
        if (rec.getMyCoordinates() != null) {
            this.append("MY_LAT", CoordinateWriter.latToDM(rec.getMyCoordinates().getLatitude()));
            this.append("MY_LON", CoordinateWriter.lonToDM(rec.getMyCoordinates().getLongitude()));
        }
        this.append("MY_NAME", rec.getMyName());
        this.append("MY_POSTAL_CODE", rec.getMyPostalCode());
        this.append("MY_RIG", rec.getMyRig());
        this.append("MY_SIG", rec.getMySig());
        this.append("MY_SIG_INFO", rec.getMySigInfo());
        this.append("MY_SOTA_REF", rec.getMySotaRef());
        this.append("MY_STATE", rec.getMyState());
        this.append("MY_STREET", rec.getMyStreet());
        this.appendStrings("MY_USACA_COUNTIES", rec.getMyUsaCaCounties());
        this.appendStrings("MY_VUCC_GRIDS", rec.getMyVuccGrids());
        this.append("NAME", rec.getName());
        this.append("NOTES", rec.getNotes());
        this.append("NR_BURSTS", rec.getNrBursts());
        this.append("NR_PINGS", rec.getNrPings());
        this.append("OPERATOR", rec.getOperator());
        this.append("OWNER_CALLSIGN", rec.getOwnerCallsign());
        this.append("PFX", rec.getPfx());
        this.append("PRECEDENCE", rec.getPrecedence());
        this.append("PROP_MODE", rec.getPropMode());
        this.append("PUBLIC_KEY", rec.getPublicKey());
        this.append("QRZCOM_QSO_UPLOAD_DATE", rec.getQrzcomQsoUploadDate());
        this.append("QRZCOM_QSO_UPLOAD_STATUS", rec.getQrzcomQsoUploadStatus());
        this.append("QSLMSG", rec.getQslMsg());
        this.append("QSLRDATE", rec.getQslRDate());
        this.append("QSLSDATE", rec.getQslSDate());
        this.append("QSL_RCVD", rec.getQslRcvd());
        this.append("QSL_RCVD_VIA", rec.getQslRcvdVia());
        this.append("QSL_SENT", rec.getQslSent());
        this.append("QSL_SENT_VIA", rec.getQslSentVia());
        this.append("QSL_VIA", rec.getQslVia());
        this.append("QSO_COMPLETE", rec.getQsoComplete());
        this.append("QSO_DATE", rec.getQsoDate());
        this.append("QSO_DATE_OFF", rec.getQsoDateOff());
        this.append("QSO_RANDOM", rec.getQsoRandom());
        this.append("QTH", rec.getQth());
        this.append("REGION", rec.getRegion());
        this.append("RIG", rec.getRig());
        this.append("RST_RCVD", rec.getRstRcvd());
        this.append("RST_SENT", rec.getRstSent());
        this.append("RX_PWR", rec.getRxPwr());
        this.append("SAT_MODE", rec.getSatMode());
        this.append("SAT_NAME", rec.getSatName());
        this.append("SFI", rec.getSfi());
        this.append("SIG", rec.getSig());
        this.append("SIG_INFO", rec.getSigInfo());
        this.append("SILENT_KEY", rec.getSilentKey());
        this.append("SKCC", rec.getSkcc());
        this.append("SOTA_REF", rec.getSotaRef());
        this.append("SRX", rec.getSrx());
        this.append("SRX_STRING", rec.getSrxString());
        this.append("STATE", rec.getState());
        this.append("STATION_CALLSIGN", rec.getStationCallsign());
        this.append("STX", rec.getStx());
        this.append("STX_STRING", rec.getStxString());
        this.append("SUBMODE", rec.getSubmode());
        this.append("SWL", rec.getSwl());
        this.append("TEN_TEN", rec.getTenTen());
        this.append("TIME_OFF", rec.getTimeOff());
        this.append("TIME_ON", rec.getTimeOn());
        this.append("TX_PWR", rec.getTxPwr());
        this.append("UKSMG", rec.getUksmg());
        this.appendStrings("USACA_COUNTIES", rec.getUsaCaCounties());
        this.appendStrings("VUCC_GRIDS", rec.getVuccGrids());
        this.append("WEB", rec.getWeb());
        this.appendCustomFields(rec.getApplicationDefinedFields());
        this.appendCustomFields(rec.getUserDefinedFields());
        this.append("MY_WWFF_REF", rec.getMyWwffRef());
        this.append("WWFF_REF", rec.getWwffRef());
        this.append("MY_ARRL_SECT", rec.getMyArrlSect());
        this.append("ALTITUDE", rec.getAltitude());
        this.append("MY_ALTITUDE", rec.getMyAltitude());
        if (rec.getPotaRef() != null) {
            this.append("POTA_REF", rec.getPotaRef().getValue());
        }
        if (rec.getMyPotaRef() != null) {
            this.append("MY_POTA_REF", rec.getMyPotaRef().getValue());
        }
        this.append("GRIDSQUARE_EXT", rec.getGridsquareExt());
        this.append("MY_GRIDSQUARE_EXT", rec.getMyGridsquareExt());
        this.append("HAMLOGEU_QSO_UPLOAD_DATE", rec.getHamlogEuQsoUploadDate());
        this.append("HAMLOGEU_QSO_UPLOAD_STATUS", rec.getHamlogEuQsoUploadStatus());
        this.append("HAMQTH_QSO_UPLOAD_DATE", rec.getHamqthQsoUploadDate());
        this.append("HAMQTH_QSO_UPLOAD_STATUS", rec.getHamqthQsoUploadStatus());
        this.appendEndOfRecord();
    }

    public void append(AdifHeader header, boolean useOrigProgramId) {
        this.append(header.getPreamble());
        this.append("adif_ver", header.getVersion());
        this.append("programid", useOrigProgramId ? header.getProgramId() : this.getClass().getCanonicalName());
        this.appendEndOfHeader();
    }
}

