/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.types.AdifType;

public final class Sota
implements AdifType {
    private final String ituPrefix;
    private final String subdivision;
    private final Integer reference;
    private static Pattern SOTA_RE = Pattern.compile("([0-9A-Z]+)/([A-Z][A-Z])-([0-9]+)", 2);

    @Override
    public String getValue() {
        Object value = "";
        if (this.ituPrefix != null && this.subdivision != null && this.reference != null) {
            value = this.ituPrefix + (String)(this.subdivision != null ? "/" + this.subdivision : "") + "-" + String.format("%03d", this.reference);
        }
        return value;
    }

    public static Sota valueOf(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        Matcher m = SOTA_RE.matcher(s);
        if (m.matches()) {
            return new Sota(m.group(1), m.group(2), Integer.parseInt(m.group(3)));
        }
        throw new IllegalArgumentException(String.format("'%s' is not a SOTA reference", s));
    }

    public String getItuPrefix() {
        return this.ituPrefix;
    }

    public String getSubdivision() {
        return this.subdivision;
    }

    public Integer getReference() {
        return this.reference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sota)) {
            return false;
        }
        Sota other = (Sota)o;
        Integer this$reference = this.getReference();
        Integer other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        String this$ituPrefix = this.getItuPrefix();
        String other$ituPrefix = other.getItuPrefix();
        if (this$ituPrefix == null ? other$ituPrefix != null : !this$ituPrefix.equals(other$ituPrefix)) {
            return false;
        }
        String this$subdivision = this.getSubdivision();
        String other$subdivision = other.getSubdivision();
        return !(this$subdivision == null ? other$subdivision != null : !this$subdivision.equals(other$subdivision));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : ((Object)$reference).hashCode());
        String $ituPrefix = this.getItuPrefix();
        result = result * 59 + ($ituPrefix == null ? 43 : $ituPrefix.hashCode());
        String $subdivision = this.getSubdivision();
        result = result * 59 + ($subdivision == null ? 43 : $subdivision.hashCode());
        return result;
    }

    public String toString() {
        return "Sota(ituPrefix=" + this.getItuPrefix() + ", subdivision=" + this.getSubdivision() + ", reference=" + this.getReference() + ")";
    }

    public Sota(String ituPrefix, String subdivision, Integer reference) {
        this.ituPrefix = ituPrefix;
        this.subdivision = subdivision;
        this.reference = reference;
    }
}

