/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.grid;

import org.gavaghan.geodesy.GlobalCoordinates;

public class MaidenheadCalculator {
    public static double[] MAIDENHEAD_LON_PRECISION = new double[]{20.0, 2.0, 0.0833333333, 0.00833333333};
    public static double[] MAIDENHEAD_LAT_PRECISION = new double[]{10.0, 1.0, 0.0416666665, 0.00416666665};
    public static int[] MAIDENHEAD_CHARS = new int[]{65, 48, 97, 48};

    public static String toMaidenhead(GlobalCoordinates coordinates, int precision) {
        StringBuffer locator = new StringBuffer();
        double locatorLatitude = coordinates.getLatitude() + 90.0;
        double locatorLongitude = coordinates.getLongitude() + 180.0;
        for (int i = 0; i < precision; ++i) {
            int squareLatitude = (int)(locatorLatitude / MAIDENHEAD_LAT_PRECISION[i]);
            int squareLongitude = (int)(locatorLongitude / MAIDENHEAD_LON_PRECISION[i]);
            locatorLatitude -= MAIDENHEAD_LAT_PRECISION[i] * (double)squareLatitude;
            locatorLongitude -= MAIDENHEAD_LON_PRECISION[i] * (double)squareLongitude;
            locator.append((char)(squareLongitude + MAIDENHEAD_CHARS[i]));
            locator.append((char)(squareLatitude + MAIDENHEAD_CHARS[i]));
        }
        return locator.toString();
    }

    public static GlobalCoordinates fromMaidenhead(String locator) {
        int precision = locator.length() / 2;
        if (precision > 4) {
            precision = 4;
        }
        double latitude = 0.0;
        double longitude = 0.0;
        for (int i = 0; i < precision; ++i) {
            char lon = locator.charAt(i * 2);
            char lat = locator.charAt(i * 2 + 1);
            longitude += MAIDENHEAD_LON_PRECISION[i] * (double)(lon - MAIDENHEAD_CHARS[i]);
            latitude += MAIDENHEAD_LAT_PRECISION[i] * (double)(lat - MAIDENHEAD_CHARS[i]);
        }
        return new GlobalCoordinates(latitude - 90.0, longitude - 180.0);
    }
}

