/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity;

import java.time.ZonedDateTime;
import org.apache.commons.lang3.StringUtils;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.coords.GlobalCoords3D;

public abstract class Activity
implements Comparable<Activity> {
    private ActivityType type;
    private String name;
    private String ref;
    private GlobalCoords3D coords;
    private String grid;
    private Double altitude;

    public Activity(ActivityType type) {
        this.type = type;
    }

    public boolean hasCoords() {
        return this.coords != null;
    }

    public boolean hasAltitude() {
        return this.altitude != null;
    }

    public boolean hasGrid() {
        return StringUtils.isNotEmpty((CharSequence)this.grid);
    }

    public abstract String getUrl();

    public String getAltitudeInMetres() {
        return String.format("%.0f m", this.altitude);
    }

    public boolean equals(Object other) {
        boolean rtn = false;
        if (other instanceof Activity) {
            Activity otherActivity = (Activity)other;
            rtn = otherActivity.getRef().equals(this.ref);
        }
        return rtn;
    }

    @Override
    public int compareTo(Activity other) {
        String ref = this.getRef() != null ? this.getRef() : "";
        String otherRef = other.getRef() != null ? other.getRef() : "";
        return ref.compareTo(otherRef);
    }

    public boolean isValid(ZonedDateTime onDate) {
        return true;
    }

    public boolean inRadius(Activity other, double radius) {
        GeodeticCalculator calculator = new GeodeticCalculator();
        GeodeticCurve curve = calculator.calculateGeodeticCurve(Ellipsoid.WGS84, (GlobalCoordinates)other.getCoords(), (GlobalCoordinates)this.coords);
        return curve.getEllipsoidalDistance() < radius && !other.equals(this);
    }

    public ActivityType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getRef() {
        return this.ref;
    }

    public GlobalCoords3D getCoords() {
        return this.coords;
    }

    public String getGrid() {
        return this.grid;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public void setType(ActivityType type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setCoords(GlobalCoords3D coords) {
        this.coords = coords;
    }

    public void setGrid(String grid) {
        this.grid = grid;
    }

    public void setAltitude(Double altitude) {
        this.altitude = altitude;
    }

    public Activity() {
    }
}

