/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityType;

public class ActivityDatabase {
    private final ActivityType type;
    private final Map<String, Activity> database;
    private final boolean specialEventActivity;

    public ActivityDatabase(ActivityType type, Map<String, Activity> database) {
        this.type = type;
        this.database = database;
        this.specialEventActivity = false;
    }

    public ActivityDatabase(ActivityType type, Map<String, Activity> database, boolean specialEventActivity) {
        this.type = type;
        this.database = database;
        this.specialEventActivity = specialEventActivity;
    }

    public Activity get(String ref) {
        return this.database.get(ref);
    }

    public Activity get(String ref, ZonedDateTime onDate) {
        Activity activity = this.database.get(ref);
        if (activity.isValid(onDate)) {
            return activity;
        }
        return null;
    }

    public Collection<Activity> getValues() {
        return this.database.values();
    }

    public Collection<Activity> findActivitiesInRadius(Activity centre, double radius, ZonedDateTime onDate) {
        if (centre.hasCoords()) {
            return this.database.values().parallelStream().filter(Activity::hasCoords).filter(match -> match.isValid(onDate)).filter(match -> match.inRadius(centre, radius * 1000.0)).collect(Collectors.toUnmodifiableList());
        }
        return new ArrayList<Activity>();
    }

    public int size() {
        return this.database.size();
    }

    public ActivityType getType() {
        return this.type;
    }

    public boolean isSpecialEventActivity() {
        return this.specialEventActivity;
    }
}

