/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity.cota;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityDatabase;
import uk.m0nom.adifproc.activity.cota.CotaInfo;

public class CotaCsvWriter {
    private static final Logger logger = Logger.getLogger(CotaCsvWriter.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void write(ActivityDatabase cotaDatabase) throws FileNotFoundException {
        HashMap cotaBasedOnCountry = new HashMap();
        for (Activity activity : cotaDatabase.getValues()) {
            CotaInfo cota = (CotaInfo)activity;
            String country = cota.getRef().split("-")[0];
            if (cotaBasedOnCountry.get(country) == null) {
                ArrayList countryCota = new ArrayList();
                cotaBasedOnCountry.put(country, countryCota);
            }
            ((List)cotaBasedOnCountry.get(country)).add(cota);
        }
        String[] HEADERS = new String[]{"COTA WCA", "CASTLES", "PREFIX", "NAME OF CASTLE", "LOCATION", "INFORMATION", "LAT LONG", "LOCATION SOURCE"};
        for (String country : cotaBasedOnCountry.keySet()) {
            BufferedWriter out = null;
            String outPath = "target/cotaCsv";
            Files.createDirectories(Paths.get(outPath, new String[0]), new FileAttribute[0]);
            File outFile = new File(String.format("%s/%s.csv", outPath, country.toUpperCase()));
            out = new BufferedWriter(new FileWriter(outFile, StandardCharsets.ISO_8859_1));
            try (CSVPrinter printer = new CSVPrinter((Appendable)out, CSVFormat.DEFAULT.withHeader(HEADERS));){
                int record = 1;
                for (CotaInfo info : (List)cotaBasedOnCountry.get(country)) {
                    String coordsString = "";
                    String locationSource = "";
                    if (info.getCoords() != null) {
                        coordsString = String.format("%.5f, %.5f", info.getCoords().getLatitude(), info.getCoords().getLongitude());
                        locationSource = info.getCoords().getLocationInfo().toString();
                    }
                    printer.printRecord(new Object[]{info.getRef(), info.getNoCastles(), info.getPrefix(), info.getName(), info.getLocation(), info.getInformation(), coordsString, locationSource});
                    ++record;
                }
                logger.info(String.format("Wrote %d records to %s", record, outFile.getAbsolutePath()));
            }
            try {
                assert (out != null);
                out.close();
            }
            catch (IOException ioe) {
                logger.severe(String.format("Exception closing COTA country file %s: %s", country, ioe.getMessage()));
            }
            continue;
            catch (IOException e) {
                try {
                    logger.severe(String.format("Exception writing COTA country file %s: %s", country, e.getMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        assert (out != null);
                        out.close();
                    }
                    catch (IOException ioe) {
                        logger.severe(String.format("Exception closing COTA country file %s: %s", country, ioe.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    assert (out != null);
                    out.close();
                }
                catch (IOException ioe) {
                    logger.severe(String.format("Exception closing COTA country file %s: %s", country, ioe.getMessage()));
                }
            }
        }
    }
}

