/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.marsik.ham.adif.Adif3;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.AdifHeader;
import org.marsik.ham.adif.enums.Mode;
import org.marsik.ham.adif.enums.Submode;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.adif3.UnsupportedHeaderException;
import uk.m0nom.adifproc.adif3.contacts.Qsos;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.adif3.transform.CommentParsingAdifRecordTransformer;
import uk.m0nom.adifproc.adif3.transform.MyCallsignCheck;
import uk.m0nom.adifproc.adif3.transform.MyCallsignCheckResults;
import uk.m0nom.adifproc.adif3.transform.TransformResults;
import uk.m0nom.adifproc.db.LogRepository;
import uk.m0nom.adifproc.domain.Log;
import uk.m0nom.adifproc.progress.ProgressFeedbackHandlerCallback;

@Service
public class Adif3Transformer {
    private final CommentParsingAdifRecordTransformer transformer;
    private LogRepository logRepository;
    private final Map<Mode, ModeSubmode> modeImportOnlyMap = new HashMap<Mode, ModeSubmode>(){
        {
            this.put(Mode.AMTORFEC, new ModeSubmode(Mode.TOR, Submode.AMTORFEC));
            this.put(Mode.ASCI, new ModeSubmode(Mode.RTTY, Submode.ASCI));
            this.put(Mode.CHIP64, new ModeSubmode(Mode.CHIP, Submode.CHIP64));
            this.put(Mode.CHIP128, new ModeSubmode(Mode.CHIP, Submode.CHIP128));
            this.put(Mode.C4FM, new ModeSubmode(Mode.DIGITALVOICE, Submode.C4FM));
            this.put(Mode.DSTAR, new ModeSubmode(Mode.DIGITALVOICE, Submode.DSTAR));
            this.put(Mode.DOMINOF, new ModeSubmode(Mode.DOMINO, Submode.DOMINOF));
            this.put(Mode.FMHELL, new ModeSubmode(Mode.HELL, Submode.FMHELL));
            this.put(Mode.FSK31, new ModeSubmode(Mode.PSK, Submode.FSK31));
            this.put(Mode.FT4, new ModeSubmode(Mode.MFSK, Submode.FT4));
            this.put(Mode.GTOR, new ModeSubmode(Mode.TOR, Submode.GTOR));
            this.put(Mode.HELL80, new ModeSubmode(Mode.HELL, Submode.HELL80));
            this.put(Mode.HFSK, new ModeSubmode(Mode.HELL, Submode.HFSK));
            this.put(Mode.JT4A, new ModeSubmode(Mode.JT4, Submode.JT4A));
            this.put(Mode.JT4B, new ModeSubmode(Mode.JT4, Submode.JT4B));
            this.put(Mode.JT4C, new ModeSubmode(Mode.JT4, Submode.JT4B));
            this.put(Mode.JT4D, new ModeSubmode(Mode.JT4, Submode.JT4D));
            this.put(Mode.JT4E, new ModeSubmode(Mode.JT4, Submode.JT4E));
            this.put(Mode.JT4F, new ModeSubmode(Mode.JT4, Submode.JT4F));
            this.put(Mode.JT4G, new ModeSubmode(Mode.JT4, Submode.JT4G));
            this.put(Mode.JT65A, new ModeSubmode(Mode.JT65, Submode.JT65A));
            this.put(Mode.JT65B, new ModeSubmode(Mode.JT65, Submode.JT65B));
            this.put(Mode.JT65C, new ModeSubmode(Mode.JT65, Submode.JT65C));
            this.put(Mode.MFSK8, new ModeSubmode(Mode.MFSK, Submode.MFSK8));
            this.put(Mode.MFSK16, new ModeSubmode(Mode.MFSK, Submode.MFSK16));
            this.put(Mode.PAC2, new ModeSubmode(Mode.PAC, Submode.PAC2));
            this.put(Mode.PAC3, new ModeSubmode(Mode.PAC, Submode.PAC3));
            this.put(Mode.PAX2, new ModeSubmode(Mode.PAX, Submode.PAX2));
            this.put(Mode.PCW, new ModeSubmode(Mode.CW, Submode.PCW));
            this.put(Mode.PSK10, new ModeSubmode(Mode.PSK, Submode.PSK10));
            this.put(Mode.PSK31, new ModeSubmode(Mode.PSK, Submode.PSK31));
            this.put(Mode.PSK63, new ModeSubmode(Mode.PSK, Submode.PSK63));
            this.put(Mode.PSK63F, new ModeSubmode(Mode.PSK, Submode.PSK63F));
            this.put(Mode.PSK125, new ModeSubmode(Mode.PSK, Submode.PSK125));
            this.put(Mode.PSKAM10, new ModeSubmode(Mode.PSK, Submode.PSKAM10));
            this.put(Mode.PSKAM31, new ModeSubmode(Mode.PSK, Submode.PSKAM31));
            this.put(Mode.PSKAM50, new ModeSubmode(Mode.PSK, Submode.PSKAM50));
            this.put(Mode.PSKFEC31, new ModeSubmode(Mode.PSK, Submode.PSKFEC31));
            this.put(Mode.PSKHELL, new ModeSubmode(Mode.HELL, Submode.PSKHELL));
            this.put(Mode.QPSK31, new ModeSubmode(Mode.PSK, Submode.QPSK31));
            this.put(Mode.QPSK63, new ModeSubmode(Mode.PSK, Submode.QPSK63));
            this.put(Mode.QPSK125, new ModeSubmode(Mode.PSK, Submode.QPSK125));
            this.put(Mode.THRBX, new ModeSubmode(Mode.THRB, Submode.THRBX));
            this.put(Mode.LSB, new ModeSubmode(Mode.SSB, Submode.LSB));
            this.put(Mode.USB, new ModeSubmode(Mode.SSB, Submode.USB));
            this.put(Mode.VARA_HF, new ModeSubmode(Mode.DYNAMIC, Submode.VARA_HF));
            this.put(Mode.JS8, new ModeSubmode(Mode.MFSK, Submode.JS8));
        }
    };

    public Qsos transform(Adif3 log, TransformControl control, TransformResults results, ProgressFeedbackHandlerCallback progressFeedbackHandlerCallback, String sessionId) throws UnsupportedHeaderException {
        Qsos qsos = new Qsos(log);
        int firstError = 0;
        int index = 1;
        String additionalInfo = "";
        int myCallsignIssues = 0;
        int theirCallsignIssues = 0;
        MyCallsignCheckResults callsigns = MyCallsignCheck.checkForSingleMyCallsign(log);
        Log logRecord = new Log(callsigns.getCallsignsForUserLog());
        this.logRepository.save(logRecord);
        log.setRecords(this.stripLotwEofRecordIfPresent(log.getRecords()));
        for (Adif3Record rec : log.getRecords()) {
            boolean haveTheirCallsign;
            boolean haveMyCallsign;
            progressFeedbackHandlerCallback.sendProgressUpdate(sessionId, String.format("Processing contact %s", rec.getCall()));
            this.migrateAdifImportOnlyFields(rec);
            if (StringUtils.isBlank((String)rec.getOperator()) && callsigns.isOneOperator()) {
                rec.setOperator(callsigns.getSingleOperator());
            }
            if (StringUtils.isBlank((String)rec.getStationCallsign()) && callsigns.isOneStationCallsign()) {
                rec.setStationCallsign(callsigns.getSingleStationCallsign());
            }
            boolean bl = haveMyCallsign = rec.getStationCallsign() != null || rec.getOperator() != null;
            if (!haveMyCallsign && StringUtils.isNotBlank((String)control.getCallsign())) {
                rec.setStationCallsign(control.getCallsign());
                haveMyCallsign = true;
            }
            boolean bl2 = haveTheirCallsign = rec.getCall() != null;
            if (haveMyCallsign && haveTheirCallsign) {
                this.transformer.transform(control, results, qsos, rec, index);
            } else {
                if (!haveMyCallsign) {
                    ++myCallsignIssues;
                    if (firstError == 0) {
                        firstError = index;
                        additionalInfo = String.format("record %d%s", firstError, StringUtils.defaultIfEmpty((String)String.format(", their call: %s", rec.getCall()), (String)""));
                    }
                }
                if (!haveTheirCallsign) {
                    ++theirCallsignIssues;
                    if (firstError == 0) {
                        firstError = index;
                        additionalInfo = String.format("record %d", firstError);
                    }
                }
            }
            ++index;
        }
        if (theirCallsignIssues > 0) {
            results.setError(String.format("CALL not defined for %d record(s), first error on %s", theirCallsignIssues, additionalInfo));
        } else if (myCallsignIssues > 0) {
            results.setError("STATION_CALLSIGN or OPERATOR not defined, enter it on the form above as 'Your Callsign'");
        }
        AdifHeader header = new AdifHeader();
        header.setProgramId("M0NOM ADIF Processor");
        header.setProgramVersion("1.2");
        log.setHeader(header);
        return qsos;
    }

    private void migrateAdifImportOnlyFields(Adif3Record rec) {
        if (this.modeImportOnlyMap.containsKey(rec.getMode())) {
            ModeSubmode migrationPath = this.modeImportOnlyMap.get(rec.getMode());
            rec.setMode(migrationPath.getMode());
            rec.setSubmode(migrationPath.getSubmode().adifCode());
        }
    }

    private List<Adif3Record> stripLotwEofRecordIfPresent(List<Adif3Record> records) {
        ArrayList<Adif3Record> processedRecords = new ArrayList<Adif3Record>(records.size());
        for (Adif3Record rec : records) {
            if (rec.getApplicationDefinedField("APP_LOTW_EOF") != null) continue;
            processedRecords.add(rec);
        }
        return processedRecords;
    }

    public Adif3Transformer(CommentParsingAdifRecordTransformer transformer, LogRepository logRepository) {
        this.transformer = transformer;
        this.logRepository = logRepository;
    }

    private static class ModeSubmode {
        Mode mode;
        Submode submode;

        public Mode getMode() {
            return this.mode;
        }

        public Submode getSubmode() {
            return this.submode;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
        }

        public void setSubmode(Submode submode) {
            this.submode = submode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModeSubmode)) {
                return false;
            }
            ModeSubmode other = (ModeSubmode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Mode this$mode = this.getMode();
            Mode other$mode = other.getMode();
            if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
                return false;
            }
            Submode this$submode = this.getSubmode();
            Submode other$submode = other.getSubmode();
            return !(this$submode == null ? other$submode != null : !this$submode.equals(other$submode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModeSubmode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Mode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            Submode $submode = this.getSubmode();
            result = result * 59 + ($submode == null ? 43 : $submode.hashCode());
            return result;
        }

        public String toString() {
            return "Adif3Transformer.ModeSubmode(mode=" + String.valueOf(this.getMode()) + ", submode=" + String.valueOf(this.getSubmode()) + ")";
        }

        public ModeSubmode(Mode mode, Submode submode) {
            this.mode = mode;
            this.submode = submode;
        }
    }
}

