/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.contacts;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.marsik.ham.adif.Adif3Record;
import uk.m0nom.adifproc.adif3.contacts.Station;
import uk.m0nom.adifproc.qrz.QrzCallsign;

public class Qso {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm");
    private int index;
    private Station from;
    private Station to;
    private Adif3Record record;

    public Qso(Adif3Record rec, int index) {
        this.setIndex(index);
        this.setRecord(rec);
    }

    public boolean doingSameActivity() {
        return this.from.doingSameActivityAs(this.to);
    }

    public boolean isSatelliteContact() {
        return this.record != null && this.record.getSatName() != null;
    }

    public boolean isQslViaBureau() {
        QrzCallsign qrzInfo;
        boolean viaBureau = false;
        if (this.to.getQrzInfo() != null && (qrzInfo = this.to.getQrzInfo()).getQslmgr() != null) {
            String qslMgr = qrzInfo.getQslmgr().toUpperCase();
            viaBureau |= qslMgr.contains("BUREAU") || qslMgr.contains("BURO");
        }
        if (this.record != null && this.record.getQslVia() != null) {
            viaBureau |= this.record.getQslVia().toUpperCase().contains("BUREAU");
        }
        return viaBureau;
    }

    public String toString() {
        ZonedDateTime contactDateTime = this.record.getQsoDate().with(this.record.getTimeOn());
        return String.format("%s %s %s", dateTimeFormatter.format(contactDateTime), this.record.getStationCallsign(), this.record.getCall());
    }

    public int getIndex() {
        return this.index;
    }

    public Station getFrom() {
        return this.from;
    }

    public Station getTo() {
        return this.to;
    }

    public Adif3Record getRecord() {
        return this.record;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setFrom(Station from) {
        this.from = from;
    }

    public void setTo(Station to) {
        this.to = to;
    }

    public void setRecord(Adif3Record record) {
        this.record = record;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Qso)) {
            return false;
        }
        Qso other = (Qso)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        Station this$from = this.getFrom();
        Station other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Station this$to = this.getTo();
        Station other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        Adif3Record this$record = this.getRecord();
        Adif3Record other$record = other.getRecord();
        return !(this$record == null ? other$record != null : !((Object)this$record).equals(other$record));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Qso;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        Station $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Station $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        Adif3Record $record = this.getRecord();
        result = result * 59 + ($record == null ? 43 : ((Object)$record).hashCode());
        return result;
    }

    public Qso() {
    }
}

