/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.xsdquery;

import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3ElementDictionary;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3Field;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3Schema;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3SchemaLoader;

public class Adif3ElementHashedDictionary
implements Adif3ElementDictionary {
    private Map<String, Adif3Field> dictionary;

    public Adif3ElementHashedDictionary() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("adif/adx314.xsd");
        Adif3Schema schema = Adif3SchemaLoader.loadAdif3Schema(inputStream);
        this.dictionary = new HashMap<String, Adif3Field>();
        assert (schema != null);
        for (Adif3Field element : schema.getFields().values()) {
            this.dictionary.put(element.getName(), element);
        }
        HashMap<String, Adif3Field> minMap = new HashMap<String, Adif3Field>();
        this.dictionary.keySet().stream().filter(name -> name.length() <= 3).sorted(Comparator.comparingInt(String::length)).forEach(name -> minMap.put((String)name, this.dictionary.get(name)));
        this.dictionary.keySet().stream().filter(name -> name.length() > 2).sorted(Comparator.comparingInt(String::length)).forEach(name -> {
            int len = name.length();
            while (len >= 2) {
                String nameLessLastChar = name.substring(0, len - 1);
                if (minMap.get(nameLessLastChar) != null || this.dictionary.get(nameLessLastChar) != null) {
                    minMap.put(name.substring(0, len), this.dictionary.get(name));
                    len = 0;
                    continue;
                }
                if (nameLessLastChar.endsWith("_")) {
                    minMap.put(name.substring(0, len), this.dictionary.get(name));
                    len = 0;
                    continue;
                }
                if (len == 2) {
                    minMap.put(name.substring(0, len), this.dictionary.get(name));
                    len = 0;
                    continue;
                }
                len = nameLessLastChar.length();
            }
        });
        this.dictionary = minMap;
    }

    @Override
    public Adif3Field getField(String name) {
        for (int len = name.length(); len > 1; --len) {
            Adif3Field element = this.dictionary.get(name.substring(0, len));
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public Map<String, Adif3Field> getDictionary() {
        return this.dictionary;
    }
}

