/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.antenna;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.antenna.Antenna;
import uk.m0nom.adifproc.antenna.AntennaType;

@Service
public class AntennaService {
    private final Map<String, Antenna> antennaMap = new HashMap<String, Antenna>();

    public AntennaService() {
        Antenna vertical = new Antenna(AntennaType.VERTICAL, "Vertical", 15.0);
        this.antennaMap.put(vertical.getName(), vertical);
        Antenna dipole = new Antenna(AntennaType.DIPOLE, "Dipole", 20.0);
        this.antennaMap.put(dipole.getName(), dipole);
        Antenna invertedV = new Antenna(AntennaType.INV_V, "Inverted-V", 25.0);
        this.antennaMap.put(invertedV.getName(), invertedV);
        Antenna sloper = new Antenna(AntennaType.SLOPER, "Sloper", 25.0);
        this.antennaMap.put(sloper.getName(), sloper);
        Antenna yagi = new Antenna(AntennaType.YAGI, "YAGI", 10.0);
        this.antennaMap.put(yagi.getName(), yagi);
    }

    public Antenna getAntenna(String name) {
        return this.antennaMap.get(name);
    }

    public List<Antenna> getAntennas() {
        return this.antennaMap.values().stream().sorted().collect(Collectors.toList());
    }

    public List<String> getAntennaNames() {
        return this.antennaMap.values().stream().sorted().map(Antenna::getName).collect(Collectors.toList());
    }
}

